% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viridisPalette.R
\name{viridisPalette}
\alias{viridisPalette}
\title{Simple viridisLite wrapper}
\usage{
viridisPalette(
  total_colors,
  color_palette = "viridis",
  alpha = 1,
  direction = 1
)
}
\arguments{
\item{total_colors}{number of colors desired}

\item{color_palette}{A character string indicating the color map option to use. Eight options are available: "viridis","cividis","magma","inferno","plasma","rocket","mako","turbo"}

\item{alpha}{The alpha transparency, a number in [0,1]}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed}
}
\value{
Specified color palette of length `total_colors`
}
\description{
Simple viridisLite wrapper
}
\examples{
viridisPalette(5)
viridisPalette(5,color_palette='magma',alpha=0.5)
viridisPalette(5,color_palette='plasma',alpha=0.6,direction=-1)
}
