% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_2Dhist.r
\name{ggInterval_2Dhist}
\alias{ggInterval_2Dhist}
\title{visualize a 2-dimension histogram by symbolic data with ggplot
package.}
\usage{
ggInterval_2Dhist(data = NULL,mapping = aes(NULL)
,xBins = 14,yBins=16,removeZero = FALSE,
addFreq = TRUE)
}
\arguments{
\item{data}{A ggESDA object.It can also be either RSDA object or
classical data frame,which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{xBins}{x axis bins, which mean how many partials
x variable will be separate into.}

\item{yBins}{y axis bins.It is the same as xBins.}

\item{removeZero}{whether remove data whose frequency is equal to zero}

\item{addFreq}{where add frequency text in each cells.}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the two continuous variable distribution
by dividing both the x axis and y axis into bins,and calculating
the frequency of observation interval in each bin.
}
\examples{
ggInterval_2Dhist(oils, aes(x = GRA, y = FRE),
  xBins = 5, yBins = 5)

}
