% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_radar.r
\name{ggInterval_radar}
\alias{ggInterval_radar}
\title{A interval Radar plot}
\usage{
ggInterval_radar(data=NULL,layerNumber=3,
inOneFig=TRUE,showLegend=TRUE,showXYLabs=FALSE,
plotPartial=NULL,
alpha=0.5,
base_circle=TRUE,
base_lty=2,
addText=TRUE,
type="default",
quantileNum=4,
Drift=0.5,
addText_modal=TRUE,
addText_modal.p=FALSE)
}
\arguments{
\item{data}{A ggESDA object. It can also be either RSDA object or
classical data frame(not recommended),which will be automatically convert to ggESDA
data.}

\item{layerNumber}{number of layer of a concentric circle,usually
to visuallize the reach of a observation in particularly variable.}

\item{inOneFig}{whether plot all observations in one figure.if not,
it will generate a new windows containing distinct observations.}

\item{showLegend}{whether show the legend.}

\item{showXYLabs}{whether show the x,y axis labels.}

\item{plotPartial}{a numeric vector,which is the row index from
the data.if it is not null, it will extract the row user deciding
to draw a radar plot from original data.Notes : the data must be
an interval data if the plotPartial is not null.}

\item{alpha}{aesthetic alpha of fill color}

\item{base_circle}{boolean, if true, it will generate inner circle.}

\item{base_lty}{line type in base figure}

\item{addText}{add the value of interval-valued variables in figure}

\item{type}{different type of radar,it can be "default","rect","quantile"}

\item{quantileNum}{if type == "quantile", it will provide the number of percentage}

\item{Drift}{The drift term, which determines the radar values beginning.}

\item{addText_modal}{add the factor of modal multi-valued variables in figure..}

\item{addText_modal.p}{add the value of modal multi-valued variables in figure..}
}
\description{
Using ggplot2 package to make a radar plot with multiple
variables.Each variables contains min values and max values as a
symbolic data.
}
\examples{
mydata<-ggESDA::classic2sym(mtcars,k=4)$intervalData
ggInterval_radar(data=mydata[,c("mpg","disp",'drat')])
ggInterval_radar(data=mydata[,c("mpg","disp",'drat')],inOneFig = TRUE,plotPartial = c(2,3))


mydata<-ggESDA::classic2sym(iris,groupby = Species)$intervalData
ggInterval_radar(mydata,inOneFig = TRUE)+geom_text(aes(x=0.6,0.6),label="Add anything you want")
}
