% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_bathymetry.R
\name{vector_bathymetry}
\alias{vector_bathymetry}
\title{Create a SpatialPolygonsDataFrame bathymetry from a raster bathymetry file}
\usage{
vector_bathymetry(
  bathy,
  drop.crumbs = NULL,
  remove.holes = NULL,
  smooth = FALSE
)
}
\arguments{
\item{bathy}{bathyRaster object from the \code{\link{raster_bathymetry}} function.}

\item{drop.crumbs}{Single numeric value specifying a threshold (area in km2) for disconnected polygons which should be removed. Set to \code{NULL} to bypass the removal. Uses the \link[smoothr]{drop_crumbs} function.}

\item{remove.holes}{Single numeric value specifying a threshold (area in km2) for holes which should be removed. Set to \code{NULL} to bypass the removal. Uses the \link[smoothr]{fill_holes} function.}

\item{smooth}{Logical indicating whether the pixelated contours should be smoothed. Uses the \link[smoothr]{smooth_ksmooth} function.}
}
\value{
\link[sp:SpatialPolygons]{SpatialPolygonsDataFrame} containing the depth polygons. Uses same projection than \code{bathy} (see \code{\link[sp:CRS-class]{CRS}}).
}
\description{
Vectorizes bathymetry rasters. Designed to be used for the output of \code{\link{raster_bathymetry}} function. Warning: processing may take a long time if the bathymetry raster is large.
}
\details{
The \code{drop.crumbs} and \code{remove.holes} arguments can be used to make the resulting object smaller in file size. The \code{smooth} argument can be used to remove the pixelated contours, but often increases file size. Note also that using this option will bias the contours with respect to real world.
}
\seealso{
Other create shapefiles: 
\code{\link{clip_shapefile}()},
\code{\link{raster_bathymetry}()}
}
\author{
Mikko Vihtakari
}
\concept{create shapefiles}
