% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{get_plot}
\alias{get_plot}
\title{Get plot object}
\usage{
get_plot(ctr, nplot, npage = NULL)
}
\arguments{
\item{ctr}{\code{pmxClass} controller object}

\item{nplot}{character the plot name}

\item{npage}{integer or integer vector, set page number in case of multi pages plot}
}
\value{
ggplot object
}
\description{
Get plot object
}
\examples{
\donttest{
library(ggPMX)
ctr <- theophylline()
p1 <- ctr \%>\% get_plot("iwres_ipred")
## get all pages or some pages
p2 <- ctr \%>\% get_plot("individual")
## returns one page of individual plot
p2 <- ctr \%>\% get_plot("individual",npage=1)
p3 <- ctr \%>\% get_plot("individual",npage=c(1,3))
## get distribution plot
pdistri <- ctr \%>\% get_plot("eta_hist")

}
}
\seealso{
Other pmxclass: \code{\link{get_cats}},
  \code{\link{get_conts}}, \code{\link{get_covariates}},
  \code{\link{get_data}}, \code{\link{get_occ}},
  \code{\link{get_plot_config}}, \code{\link{get_strats}},
  \code{\link{plot_names}}, \code{\link{plots}},
  \code{\link{pmx_update}}, \code{\link{set_data}},
  \code{\link{set_plot}}
}
