% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-report.R
\name{pmx_report}
\alias{pmx_report}
\title{Generates ggpmX report from a pre-defined template}
\usage{
pmx_report(
  contr,
  name,
  save_dir,
  format = c("both", "plots", "report"),
  template = "standing",
  footnote = format == "both",
  edit = FALSE,
  extension = NULL,
  title,
  ...
)
}
\arguments{
\item{contr}{\code{pmxClass} controller}

\item{name}{\code{character} The report name}

\item{save_dir}{Output directory.  A directory to write the results files to}

\item{format}{\code{character} the result type, can be \cr
a standalone directory of plots or a report document as defined in the template \cr
(pdf, docx,..) ,or both}

\item{template}{\code{character} ggPMX predefined template or the
path to a custom rmarkdwon template. \cr
Use \code{\link{pmx_report_template}} to get the list
of available templates}

\item{footnote}{\code{logical}  TRUE to add a footnote to the generated plots. The default footnote is to add \cr
the path where the plot is saved.}

\item{edit}{\code{logical}  TRUE to edit the template immediately}

\item{extension}{\code{character} The output document format. By default, a word report is generated. \cr
User can specify one or more formats from c("word","pdf","html","all"). extnestion "all" to generate all formats.}

\item{title}{\code{character} report title (optional)}

\item{...}{extra parameters depending in the template used}
}
\description{
Generates ggpmX report from a pre-defined template
}
\details{
\code{pmx_report} uses pre-defined template .Rmd to generate the report.
The idea is to pass the controller as a report argument using knitr \code{params} artifact.
}
\examples{

\donttest{
library(ggPMX)
## list of templates
## ctr \%>\% pmx_report_template()

report_dir <- tempdir()
## case1: generate a single report
## We use default save dir, 
ctr <- theophylline()
ctr \%>\% pmx_report(
  name = "my_report",
  save_dir = report_dir,
  format="report")

## case2: generate standalone plots
## Note here the use of a custom dir to save results
ctr <- theophylline()
ctr \%>\% pmx_report(
  name = "my_report",
  save_dir = report_dir,
  format="plots")


## case3: generate both : reports + plots
## by default add footnote
## Note , you can force footnote to FALSE using footnote parameter
ctr <- theophylline()
ctr \%>\% pmx_report(
  name = "my_report",
  save_dir = report_dir,
  format="both")

## case4 : generate standalone plots with footnotes
ctr <- theophylline()
ctr \%>\% pmx_report(
  name = "my_report",
  save_dir = report_dir,
  footnote=TRUE,
  format="plots")





##  case6: dynamic edit
## uncomment to run 
# ctr <- theophylline()
# ctr \%>\% pmx_report(
#   save_dir = file.path(report_dir,"case6"),
#   name = "my_report",
#   format="report",
#   edit = TRUE)


## case7 : use custom template file 

ctr <- theophylline()
custom_template <- 
  file.path( system.file(package = "ggPMX"),"examples","templates","custom_report.Rmd")
ctr \%>\% pmx_report(
  name="report2",
  save_dir = report_dir,
  template=custom_template,
  format="both"
)

## case7 : generate individual plots report 

## ctr <- theophylline()
## ctr \%>\% pmx_report(
##   name="report2",
##   save_dir = report_dir,
##   template="individual",
##   format="both",
##   which_pages=1:2
## )

## case8: misc example with complicated features
## see github issue : #179
ctr <- theophylline()
misc_template <- 
  file.path( system.file(package = "ggPMX"),"examples","templates","misc.Rmd")
ctr \%>\% pmx_report(
  name="misc",
  save_dir = report_dir,
  template=misc_template,
  format="both"
)
}

}
