% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{pmx}
\alias{pmx}
\alias{pmx_mlx}
\alias{pmx_mlxtran}
\title{Create a pmx object}
\usage{
pmx(
  config,
  sys = "mlx",
  directory,
  input,
  dv,
  dvid,
  cats = NULL,
  conts = NULL,
  occ = NULL,
  strats = NULL,
  settings = NULL,
  endpoint = NULL,
  sim = NULL,
  bloq = NULL,
  id = NULL,
  time = NULL,
  sim_blq = NULL
)

pmx_mlx(
  config,
  directory,
  input,
  dv,
  dvid,
  cats,
  conts,
  occ,
  strats,
  settings,
  endpoint,
  sim,
  bloq,
  id,
  time,
  sim_blq
)

pmx_mlxtran(
  file_name,
  config = "standing",
  call = FALSE,
  endpoint,
  version = -1,
  ...
)
}
\arguments{
\item{config}{Can be either :
The complete path for the configuration file, the name of configuration within the built-in
list of configurations, or a configuration object.}

\item{sys}{the system name can "mlx" (for Monolix 2016) or "mlx18" (for Monolix 2018/19 and later)}

\item{directory}{\code{character} modelling output directory.}

\item{input}{\code{character} complete path to the modelling input file}

\item{dv}{\code{character} the name of measurable variable used in the input modelling file}

\item{dvid}{\emph{[Optional]} \code{character} observation type parameter. This is mandatory
in case of multiple endpoint (PKPD).}

\item{cats}{\emph{[Optional]}\code{character} vector of categorical covariates}

\item{conts}{\emph{[Optional]}\code{character} vector of continuous covariates}

\item{occ}{\emph{[Optional]}\code{character} occasional covariate variable name}

\item{strats}{\emph{[Optional]}\code{character} extra stratification variables}

\item{settings}{\emph{[Optional]}\code{pmxSettingsClass} \code{\link{pmx_settings}}
shared between all plots}

\item{endpoint}{\code{pmxEndpointClass} or \code{integer} or \code{charcater} default to NULL
of the endpoint code.   \code{\link{pmx_endpoint}}}

\item{sim}{\code{pmxSimClass} default to NULL. \code{\link{pmx_sim}} used for VPC, e.g.: sim = pmx_sim(file=vpc_file, irun="rep",idv="TIME")}

\item{bloq}{\code{pmxBLOQClass} default to NULL. \code{\link{pmx_bloq}} specify bloq, within controller: e.g. bloq=pmx_bloq(cens = "BLOQ_name", limit = "LIMIT_name")}

\item{id}{\emph{[Optional]}  \code{character} the name of Indvidual variable used in the input modelling file}

\item{time}{\emph{[Optional]} \code{character} Time variable.}

\item{sim_blq}{\code{logical} if TRUE uses sim_blq values for plotting. Only for Monolix 2018 and later.}

\item{file_name}{\code{character} mlxtran file path.}

\item{call}{\code{logical} if TRUE the result is the parameters parsed}

\item{version}{\code{integer} Non-negative integer. Non-obligatory option, if you don't use a wildcard in the file_name.
Otherwise you MUST provide version and wildcard will be substituted with "version", which represents the mlxtran model version.}

\item{...}{extra arguments passed to pmx_mlx.}
}
\value{
\code{pmxClass} controller object.
}
\description{
Create a pmx object from a data source
}
\details{
\code{pmx_mlx}  is a wrapper to mlx for the MONOLIX system ( \code{sys="mlx"})

\code{pmx_mlxtran} parses mlxtran file and guess \code{\link{pmx_mlx}} arguments. In case of
multi endpoint the first endpoint is selected. You can though set the endpoint through the same argument.
When you set \code{call=TRUE},no controller is created but only the parameters parsed
by mlxtran. This can be very helpful, in case you would like to customize parameters
(adding settings vi pmx_settings, chnag eth edefault endpoint.)
}
\examples{
\donttest{

## Example to create the controller using theophylline data
theophylline <- file.path(system.file(package = "ggPMX"), "testdata",
                          "theophylline")
WORK_DIR <- file.path(theophylline, "Monolix")
input_file <- file.path(theophylline, "data_pk.csv")

## using only mandatory variables
ctr <- pmx(
  sys="mlx",
  config = "standing",
  directory = WORK_DIR,
  input = input_file,
  dv = "Y",
  dvid ="DVID"
)
## Using covariates
ctr <- pmx(
  sys="mlx",
  config = "standing",
  directory = WORK_DIR,
  input = input_file,
  dv = "Y",
  dvid ="DVID",
  cats=c("SEX"),
  conts=c("WT0","AGE0"),
  strats="STUD"
)
## using settings parameter
ctr <- pmx(
  sys="mlx",
  config = "standing",
  directory = WORK_DIR,
  input = input_file,
  dv = "Y",
  dvid ="DVID",
  settings=list(is.draft=FALSE)
)

## using mlxtran file
mlxtran_file <- 
  file.path(system.file(package = "ggPMX"), 
    "testdata","1_popPK_model","project.mlxtran")
pmx_mlxtran(mlxtran_file)

## mlxtran , call =TRUE to get the pmx_mlx argument parsed by  pmx_mlxtran
params <- pmx_mlxtran(mlxtran_file,call=TRUE)

str(params)
# $ directory: chr results_pathile 
# $ input    : chr observation file path
# $ dv       : chr "DV"
# $ cats     : chr [1:4] "SEX" "RACE" "DISE" "ILOW"
# $ conts    : chr [1:4] "AGE0" "WT0" "HT0" "TRT"
# $ occ      : chr "ISS"
# $ dvid     : chr "YTYPE"
# $ endpoint :List of 5
# ..$ code     : chr "1"
# ..$ label    : chr ""
# ..$ unit     : chr ""
# ..$ file.code: chr "1"
# ..$ trans    : NULL
# ..- attr(*, "class")= chr "pmxEndpointClass"
# $ config   : chr "standing"
}
}
