% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_Summay__Capability_FUNs.R
\name{capability.summary}
\alias{capability.summary}
\title{Calculate Summary of Quality Performance Parameters}
\usage{
capability.summary(LSL, USL, QC.Center, QC.Sigma, s.Sigma, digits = 2)
}
\arguments{
\item{LSL}{number, customer's lower specification limit.}

\item{USL}{number, customer's upper specification limit.}

\item{QC.Center}{number, the mean or median value determined from an XmR plot or a Studentized (e.g., xBar) analysis.}

\item{QC.Sigma}{number, the sigma value determined from an XmR plot or a Studentized (e.g., xBar) analysis.}

\item{s.Sigma}{number, the sigma value determined from overall standard deviation (i.e., sd()).}

\item{digits}{integer, how many digits to report.}
}
\value{
data frame , listing of metric lebel and value
}
\description{
function to report listing of quality performance parameters
\itemize{
\item \bold{Proc. Tolerance (sigma)}: Describes the number of your process sigma (from QC charting) that can fit in your customer's specification window (the larger the better).
\item \bold{DNS (sigma)}: Distance to Nearest Specification (DNS) limit. Measure of how centered your process is and how close you are to the nearest process limit in sigma units.
\item \bold{Cp}: Describes how many times your 6 sigma process window (from QC charting) can fit in your customer's specification window (the larger the better)
\item \bold{Cpk}: Describes how centered your process is relative to customer specifications. How many times can you fit a 3 sigma window (from QC charting) between your process center and the nearest customer specification limit.
\item \bold{Pp}: Describes how many times your 6 sigma process window (overall standard deviation) can fit in your customer's specification window (the larger the better)
\item \bold{Ppk}: Describes how centered your process is relative to customer specifications. How many times can you fit a 3 sigma window (overall standard deviation) between your process center and the nearest customer specification limit.
}
}
