% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_minimal_vimp.ggRandomForests}
\alias{gg_minimal_vimp}
\alias{gg_minimal_vimp.ggRandomForests}
\title{Minimal depth vs VIMP camparison by variable ranks.}
\usage{
gg_minimal_vimp.ggRandomForests(object, event, ...)
}
\arguments{
\item{object}{A \code{randomForestSRC::rfsrc} object, \code{randomForestSRC::predict}
object or the list from the \code{randomForestSRC::var.select.rfsrc} function.}

\item{event}{an optional vector of logical values (event indicator) for
shaping the points in when plotting.}

\item{...}{optional arguments passed to the \code{randomForestSRC::var.select} function
 if operating on an \code{randomForestSRC::rfsrc} object.}
}
\description{
Minimal depth vs VIMP camparison by variable ranks.
}
\examples{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# iris_vs <- var.select(iris_rf)
# ... or load a cached randomForestSRC object
data(iris_vs, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf.obj<- gg_minimal_vimp(iris_vs)

# Plot the gg_mkinimal_depth object
plot(ggrf.obj)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq_rf <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# airq_vs <- var.select(airq_rf)
# ... or load a cached randomForestSRC object
data(airq_vs, package="ggRandomForests")

# Get a data.frame containing error rates
ggrf.obj<- gg_minimal_vimp(airq_vs)

# Plot the gg_error object
plot(ggrf.obj)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# veteran_vs <- var.select(veteran_rf)
# Load a cached randomForestSRC object
data(veteran_vs, package="ggRandomForests")

ggrf.obj <- gg_minimal_vimp(veteran_vs)
plot(ggrf.obj)
}
\seealso{
\code{\link{plot.gg_minimal_vimp}} \code{randomForestSRC::var.select}
}

