% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_survival.ggRandomForests}
\alias{gg_survival}
\alias{gg_survival.ggRandomForests}
\title{Predicted survival data object from an \code{randomForestSRC::rfsrc} survival object.}
\usage{
gg_survival.ggRandomForests(object, prd_type = c("std", "oob"),
  srv_type = c("surv", "chf", "mortality", "hazard"), climits = 0.95, ...)
}
\arguments{
\item{object}{An \code{randomForestSRC::rfsrc} object or \code{randomForestSRC::predict} predict,
or a survival object from \code{\link{eventtable}}.}

\item{prd_type}{("std", "oob")}

\item{srv_type}{("surv", "chf", "mortality", "hazard")}

\item{climits}{confidence limit bands}

\item{...}{Further arguments passed to other methods.}
}
\description{
Predicted survival data object from an \code{randomForestSRC::rfsrc} survival object.
}
\examples{
## veteran data
## randomized trial of two treatment regimens for lung cancer
#data(veteran, package = "randomForestSRCM")
#veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
data(veteran_rf, package="ggRandomForests")

ggrf.obj <- gg_survival(veteran_rf)
plot(ggrf.obj)
}
\seealso{
\code{\link{plot.gg_survival}} \code{\link{gg_rfsrc}} \code{randomForestSRC::rfsrc}
\code{randomForestSRC::predict} \code{\link{eventtable}}
}

