#' minimal depth interaction matrix from randomForestSRC::find.interaction. 
#' 
#' A cached object constructed from the \code{randomForestSRC::find.interaction} function 
#' for the New York Air Quality Measurements. The randomForestSRC regression forest 
#' is stored in the \code{\link{airq_rf}} object.
#'  
#' @details For ggRandomForests examples and tests, as well as streamlining the 
#' R CMD CHECK for package release, we cache the computationally expensive operations
#' from the randomForestSRC package. 
#' 
#' To test the interaction plots, we build a regression randomForest (\code{\link{airq_rf}}) 
#' with the \code{airquality} measurements data, then run the \code{find.interaction} function 
#' to determine pairwise variable interaction measures. 
#' 
#' The airq_interation "data set" is a cache of the \code{find.interaction} function, which 
#' measures pairwise interactions between variables from the \code{\link{airq_rf}} random 
#' forest model.
#' 
#' The data were from New York, from May to September 1973. The data was obtained from the 
#' New York State Department of Conservation (ozone data) and the National Weather Service 
#' (meteorological data).
#' 
#' @seealso \code{airquality} \code{find.interaction} \code{rfsrc} \code{\link{airq_rf}}
#' 
#' @examples
#' \dontrun{
#' ## The data was built with the following command
#' airq_rf <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
#' airq_interaction <- find.interaction(airq_rf)
#' 
#' gg_int <- gg_interaction(airq_interaction)
#' 
#' plot(gg_int, x_var="Temp")
#' plot(gg_int, x_var="Solar.R")
#' }
#' 
#' @references 
#' Chambers, J. M., Cleveland, W. S., Kleiner, B. and Tukey, P. A. 
#' (1983) Graphical Methods for Data Analysis. Belmont, CA: Wadsworth.
#' 
#' Ishwaran H. and Kogalur U.B. (2014). Random Forests for
#' Survival, Regression and Classification (RF-SRC), R package
#' version 1.5.4.
#' 
#' Ishwaran H. and Kogalur U.B. (2007). Random survival forests
#' for R. R News 7(2), 25-31.
#' 
#' Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S.
#' (2008). Random survival forests. Ann. Appl. Statist. 2(3),
#' 841-860.
#' 
#' @docType data
#' @keywords datasets
#' @format rdata matrix from \code{randomForestSRC::find.interaction}
#' @name mtcars_interaction
NULL
