% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{pbc_prtl_bili_prothrombin}
\alias{pbc_prtl_bili_prothrombin}
\title{Partial coplot data}
\format{A randomForestSRC::plot.variable object for survival}
\description{
Cached partial coplot for bilirubin and prothrombin interaction
 in pbc random forest for survival.
}
\examples{
\dontrun{
## Examples from randomForestSRC::rfsrc
##
data(pbc, package = "randomForestSRC")
pbc_rf <- rfsrc(Surv(days, status) ~ ., pbc, nsplit = 10)

# Get the training data to work with...
dta.train  <- pbc_rf$xvar

ggvar <- gg_var(pbc_rf)
ggvar$prothrombin_grp <- cut(pbc_rf$xvar$prothrombin, breaks=c(8.9,10,11,12,18))

# Create a series of coplot subsets....
lng <- length(levels(prothrombin_grp))
sbst <- mclapply(1:lng, function(ind){
  st <- which(dta.train$prothrombin_grp==levels(prothrombin_grp)[ind])
  if(length(st) == 0) NULL
  else st
})

lvl <- levels(prothrombin_grp)
# Collapse the subset list to interesting items
# (those with observations)
# If you work backwards, you do extra tests, but it
# cuts the correct items. Cute.
for(ind in lng:1){
  if(is.null(sbst[[ind]])){
    sbst[[ind]] <- NULL

    # reset the levels, so we can label things later
    lvl <- lvl[-ind]
  }
}

pDat.partlist <- mclapply(1:length(sbst), function(ind){
  plot.variable(pbc_rf, surv.type="surv", time=1,
                subset = sbst[[ind]],
                xvar.names="bili", partial=TRUE,
                show.plots = FALSE)
})

gg_part <- mclapply(pDat.partlist, gg_partial)

# Flip y-axis
cls <- class(gg_part)
class(gg_part) <-  c("gg_partial_list", cls)

for(ind in 1:length(gg_part)){
  gg_part[[ind]]$prothrombin <- lvl[ind]
}
pbc_prtl_bili_prothrombin <- do.call(rbind, gg_part)
pbc_prtl_bili_prothrombin$prothrombin <-
  paste("prothrombin=", pbc_prtl_bili_prothrombin$prothrombin)
pbc_prtl_bili_prothrombin$prothrombin <-
  factor(pbc_prtl_bili_prothrombin$prothrombin)

save(pbc_prtl_bili_prothrombin, file="data/pbc_prtl_bili_prothrombin.rda")

ggpl <- ggplot(gg_merge,
     aes(x=bili, y=yhat, shape=prothrombin, color=prothrombin))+
  geom_point()+geom_smooth(se=FALSE)+
  labs(x="Surgical Date", y="Survival 1 year")+
  scale_color_brewer(palette="Set1")
ggpl
 }
}
\references{
Ishwaran H. and Kogalur U.B. (2014). Random Forests for
Survival, Regression and Classification (RF-SRC), R package
version 1.5.4.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests
for R. R News 7(2), 25-31.

Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S.
(2008). Random survival forests. Ann. Appl. Statist. 2(3),
841-860.
}
\keyword{datasets}

