% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.gg_rfsrc}
\alias{print.gg_rfsrc}
\title{Print a \code{\link{gg_rfsrc}} object.}
\usage{
\method{print}{gg_rfsrc}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_rfsrc}} object.}

\item{...}{optional arguments}
}
\description{
Print a \code{\link{gg_rfsrc}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(iris_rf, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_rfsrc(iris_rf)
print(gg_dta)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
# ... or load a cached randomForestSRC object
data(airq_rf, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_rfsrc(airq_rf)
print(gg_dta)

# To nicely print a rfsrc output...
print.gg_rfsrc(airq_rf)
}

