% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_rfsrc.ggRandomForests.R
\name{gg_rfsrc.ggRandomForests}
\alias{gg_rfsrc}
\alias{gg_rfsrc.ggRandomForests}
\title{Predicted response data object}
\usage{
gg_rfsrc.ggRandomForests(object, surv_type = c("surv", "chf", "mortality",
  "hazard"), oob = TRUE, ...)
}
\arguments{
\item{object}{\code{randomForestSRC::rfsrc} object}

\item{surv_type}{("surv", "chf", "mortality", "hazard") for survival forests}

\item{oob}{boolean, should we return the oob prediction , or the full
forest prediction.}

\item{...}{not used}
}
\value{
\code{gg_rfsrc} object
}
\description{
Extracts the predicted response values from the \code{randomForestSRC::rfsrc} object,
and formats data for plotting the response using \code{\link{plot.gg_rfsrc}}.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris, package="ggRandomForests")
gg_dta<- gg_rfsrc(rfsrc_iris)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
data(rfsrc_airq, package="ggRandomForests")
gg_dta<- gg_rfsrc(rfsrc_airq)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
data(rfsrc_veteran, package = "ggRandomForests")
gg_dta <- gg_rfsrc(rfsrc_veteran)
plot(gg_dta)
plot(gg_dta, level=.68)
}
\seealso{
\code{\link{plot.gg_rfsrc}} \code{rfsrc} \code{plot.rfsrc} \code{\link{gg_survival}}
}

