% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{dendrogram_data}
\alias{dendrogram_data}
\title{Dengrogram x and y coordinates}
\usage{
dendrogram_data(
  tree,
  priority = "right",
  center = FALSE,
  type = "rectangle",
  leaf_pos = NULL,
  leaf_braches = NULL,
  reorder_branches = TRUE,
  branch_gap = NULL,
  root = NULL
)
}
\arguments{
\item{tree}{A \link[stats:hclust]{hclust} or a \link[stats:dendrogram]{dendrogram}
object.}

\item{priority}{A string of "left" or "right". if we draw from right to left,
the left will override the right, so we take the \code{"left"} as the priority. If
we draw from \code{left} to \code{right}, the right will override the left, so we take
the \code{"right"} as priority. This is used by \code{\link[=align_dendro]{align_dendro()}} to provide
support of facet operation in ggplot2.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to the leaves in the branch. Otherwise (default), plot them in the
middle of all direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{leaf_pos}{The x-coordinates of the leaf node. Must be the same length
of the number of observations in \code{tree}.}

\item{leaf_braches}{Branches of the leaf node. Must be the same length of the
number of observations in \code{tree}. Usually come from \link[stats:cutree]{cutree}.}

\item{reorder_branches}{A single boolean value, indicates whether reorder the
provided leaf_braches based on the actual index.}

\item{branch_gap}{A single numeric value indicates the gap between different
branches.}

\item{root}{A length one string or numeric indicates the root branch.}
}
\value{
A list of 2 data.frame. One for node coordinates, another for edge
coordinates.
\code{node} and tree segments \code{edge} coordinates contains following columns:
\itemize{
\item \code{index}: the original index in the tree for the current node
\item \code{label}: node label text
\item \code{x} and \code{y}: x-axis and y-axis coordinates for current node or the start
node of the current edge.
\item \code{xend} and \code{yend}: the x-axis and y-axis coordinates of the terminal node
for current edge.
\item \code{branch}: which branch current node or edge is. You can use this column
to color different groups.
\item \code{panel}: which panel current node is, if we split the plot into panel
using \link[ggplot2:facet_grid]{facet_grid}, this column will show
which panel current node or edge is from. Note: some nodes may
fall outside panel (between two panels), so there are possible
\code{NA} values in this column.
\item \code{.panel}: Similar with \code{panel} column, but always give the correct
branch for usage of the ggplot facet.
\item \code{panel1} and \code{panel2}: The panel1 and panel2 variables have the same
functionality as \code{panel}, but they are specifically for the \code{edge} data
and correspond to both nodes of each edge.
\item \code{leaf}: A logical value indicates whether current node is a leaf.
}
}
\description{
Dengrogram x and y coordinates
}
\examples{
dendrogram_data(hclust(dist(USArrests), "ave"))
}
