% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-stack-.R
\name{stack_layout}
\alias{stack_layout}
\alias{ggstack}
\title{Put plots horizontally or vertically}
\usage{
stack_layout(data = NULL, direction = NULL, type = NULL, ...)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from parent layout:
\itemize{
\item If \code{type} is \code{align}, \code{\link[=fortify_data_frame]{fortify_data_frame()}} will be used to get a data
frame.
\item If \code{type} is \code{free}, \code{\link[=fortify_matrix]{fortify_matrix()}} will be used to get a matrix.
}}

\item{direction}{A string indicating the direction of the stack layout,
either \code{"horizontal"} or \code{"vertical"}.}

\item{type}{A string indicating the stack layout type: \code{"align"} for
aligned plots (\code{\link[=stack_align]{stack_align()}}) or \code{"free"} for free stacking
(\code{\link[=stack_free]{stack_free()}}).}

\item{...}{Additional arguments passed to \code{\link[=fortify_data_frame]{fortify_data_frame()}} or
\code{\link[=fortify_matrix]{fortify_matrix()}}.}
}
\value{
A \code{StackLayout} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function integrates the functionalities of \code{stack_free()} and
\code{stack_align()} into a single interface. \code{ggstack} is an alias for
\code{stack_layout}.
}
\examples{
set.seed(123)
small_mat <- matrix(rnorm(56), nrow = 7L)
stack_layout(small_mat, "h", "align") + align_dendro()

# ggstack is an alias for `stack_layout`
ggstack(small_mat, "h", "align") + align_dendro()

# this is the same with:
stack_align(small_mat, "h") + align_dendro()
}
\seealso{
\itemize{
\item \code{\link[=stack_align]{stack_align()}}
\item \code{\link[=stack_free]{stack_free()}}
}
}
