% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-geom-gshape.R
\name{scale_gshape_manual}
\alias{scale_gshape_manual}
\title{Scale for \code{gshape} aesthetic}
\usage{
scale_gshape_manual(..., values, breaks = waiver(), na.value = NA)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{values}{A list of grobs or functions (including purrr-like lambda
syntax) that define how each cell's grob (graphical object) should be drawn.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{na.value}{The aesthetic value to use for missing (\code{NA}) values}
}
\description{
Scale for \code{gshape} aesthetic
}
\details{
\code{geom_gshape} depends on the new aesthetics \code{gshape} (shape with grid
functions), which should always be provided with \code{\link[=scale_gshape_manual]{scale_gshape_manual()}},
in which, we can provide a list of grobs or functions that define how each
value should be drawn. Any ggplot2 aesthetics can be used as the arguments.
}
\section{Aesthetics}{

\code{geom_gshape()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{\link[ggplot2:aes_position]{x}}}
\item \strong{\code{\link[ggplot2:aes_position]{y}}}
\item \strong{\code{gshape}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{alpha}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{colour}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{fill}}
\item \code{\link[ggplot2:aes_group_order]{group}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linetype}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linewidth}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{shape}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{size}}
\item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs", package = "ggplot2")}.
}

\examples{
library(grid)
ggplot(data.frame(value = letters[seq_len(5)], y = seq_len(5))) +
    geom_gshape(aes(x = 1, y = y, gshape = value, fill = value)) +
    scale_gshape_manual(values = list(
        a = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        b = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        c = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        d = function(x, y, width, height, shape) {
            gList(
                pointsGrob(x, y, pch = shape),
                # To ensure the rectangle color is shown in the legends, you
                # must explicitly provide a color argument and include it in
                # the `gpar()` of the graphical object
                rectGrob(x, y, width, height,
                    gp = gpar(col = "black", fill = NA)
                )
            )
        },
        e = function(xmin, xmax, ymin, ymax) {
            segmentsGrob(
                xmin, ymin,
                xmax, ymax,
                gp = gpar(lwd = 2)
            )
        }
    )) +
    scale_fill_brewer(palette = "Dark2") +
    theme_void()

}
