% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_xspline.r
\name{geom_xspline}
\alias{geom_xspline}
\alias{stat_xspline}
\title{Connect control points/observations with an X-spline}
\usage{
geom_xspline(mapping = NULL, data = NULL, stat = "xspline",
  position = "identity", na.rm = TRUE, show.legend = NA,
  inherit.aes = TRUE, spline_shape = -0.25, open = TRUE,
  rep_ends = TRUE, ...)

stat_xspline(mapping = NULL, data = NULL, geom = "line",
  position = "identity", na.rm = TRUE, show.legend = NA,
  inherit.aes = TRUE, spline_shape = -0.25, open = TRUE,
  rep_ends = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{spline_shape}{A numeric vector of values between -1 and 1, which
control the shape of the spline relative to the control points.}

\item{open}{A logical value indicating whether the spline is an open or a
closed shape.}

\item{rep_ends}{For open X-splines, a logical value indicating whether the
first and last control points should be replicated for drawing the
curve. Ignored for closed X-splines.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{geom, stat}{Use to override the default connection between
\code{geom_xspline} and \code{stat_xspline}.}
}
\description{
Draw an X-spline, a curve drawn relative to control points/observations.
Patterned after \code{geom_line} in that it orders the points by \code{x}
first before computing the splines.
}
\details{
\if{html}{
A sample of the output from \code{geom_xspline()}:

\figure{geom_xspline_01.png}{options: width="100\%" alt="Figure: geom_xspline_01.png"}
}

\if{latex}{
A sample of the output from \code{geom_xspline()}:

\figure{geomxspline01.pdf}{options: width=10cm}
}


An X-spline is a line drawn relative to control points. For each control
point, the line may pass through (interpolate) the control point or it may
only approach (approximate) the control point; the behaviour is determined
by a shape parameter for each control point.

If the shape parameter is greater than zero, the spline approximates the
control points (and is very similar to a cubic B-spline when the shape is
1). If the shape parameter is less than zero, the spline interpolates the
control points (and is very similar to a Catmull-Rom spline when the shape
is -1). If the shape parameter is 0, the spline forms a sharp corner at that
control point.

For open X-splines, the start and end control points must have a shape of
0 (and non-zero values are silently converted to zero).

For open X-splines, by default the start and end control points are
replicated before the curve is drawn. A curve is drawn between (interpolating
or approximating) the second and third of each set of four control points,
so this default behaviour ensures that the resulting curve starts at the
first control point you have specified and ends at the last control point.
The default behaviour can be turned off via the repEnds argument.
}
\section{Aesthetics}{

\code{geom_xspline} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{color}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\itemize{
  \item{x}
  \item{y}
}
}
\examples{
set.seed(1492)
dat <- data.frame(x=c(1:10, 1:10, 1:10),
                  y=c(sample(15:30, 10), 2*sample(15:30, 10),
                      3*sample(15:30, 10)),
                  group=factor(c(rep(1, 10), rep(2, 10), rep(3, 10)))
)

ggplot(dat, aes(x, y, group=group, color=group)) +
  geom_point() +
  geom_line()

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point() +
  geom_line() +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(spline_shape=-0.4, size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(spline_shape=0.4, size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(spline_shape=1, size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(spline_shape=0, size=0.5)

ggplot(dat, aes(x, y, group=group, color=factor(group))) +
  geom_point(color="black") +
  geom_smooth(se=FALSE, linetype="dashed", size=0.5) +
  geom_xspline(spline_shape=-1, size=0.5)
}
\references{
Blanc, C. and Schlick, C. (1995), "X-splines : A Spline Model
            Designed for the End User", in \emph{Proceedings of SIGGRAPH 95},
            pp. 377-386. \url{http://dept-info.labri.fr/~schlick/DOC/sig1.html}
}
\seealso{
\code{\link[ggplot2]{geom_line}}: Connect observations (x order);
 \code{\link[ggplot2]{geom_path}}: Connect observations;
 \code{\link[ggplot2]{geom_polygon}}: Filled paths (polygons);
 \code{\link[ggplot2]{geom_segment}}: Line segments;
 \code{\link[graphics]{xspline}};
 \code{\link[grid]{grid.xspline}}
}

