% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-beeswarm.R
\name{geom_beeswarm}
\alias{geom_beeswarm}
\title{Points, jittered to reduce overplotting using the beeswarm package}
\usage{
geom_beeswarm(mapping = NULL, data = NULL, priority = c("ascending",
  "descending", "density", "random", "none"), cex = 2, groupOnX = NULL,
  dodge.width = 0, stat = "identity", position = "quasirandom",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{priority}{Method used to perform point layout (see \code{\link{swarmx}})}

\item{cex}{Scaling for adjusting point spacing (see \code{\link{swarmx}})}

\item{groupOnX}{should jitter be added to the x axis if TRUE or y axis if FALSE (the default NULL causes the function to guess which axis is the categorical one based on the number of unique entries in each)}

\item{dodge.width}{Amount by which points from different aesthetic groups will be dodged. This requires that one of the aesthetics is a factor.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
The beeswarm geom is a convenient means to offset points within categories to reduce overplotting. Uses the beeswarm package
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "point")}
}
\examples{

  ggplot2::qplot(class, hwy, data = ggplot2::mpg, geom='beeswarm')
  # Generate fake data
  distro <- data.frame(
    'variable'=rep(c('runif','rnorm'),each=100),
    'value'=c(runif(100, min=-3, max=3), rnorm(100))
  )
  ggplot2::qplot(variable, value, data = distro, geom='beeswarm')
  ggplot2::qplot(variable, value, data = distro) +
    geom_beeswarm(priority='density',cex=2.5)
}
\seealso{
\code{\link{geom_quasirandom}} an alternative method,
 \code{\link[beeswarm]{swarmx}} how spacing is determined,
 \code{\link[ggplot2]{geom_point}} for regular, unjittered points,
 \code{\link[ggplot2]{geom_jitter}} for jittered points,
 \code{\link[ggplot2]{geom_boxplot}} for another way of looking at the conditional
    distribution of a variable
}

