% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_theme.R
\name{gg_theme}
\alias{gg_theme}
\title{Quick theme for a ggplot.}
\usage{
gg_theme(
  family = "",
  title_pal = "#000000",
  title_family = NULL,
  title_size = 11,
  title_face = "bold",
  subtitle_family = NULL,
  subtitle_pal = "#323232",
  subtitle_size = 10,
  subtitle_face = "plain",
  body_family = NULL,
  body_pal = "#323232",
  body_size = 10,
  body_face = "plain",
  caption_family = NULL,
  caption_pal = "#7F7F7F",
  caption_size = 9,
  caption_face = "plain",
  axis_size = 0.3,
  axis_pal = "#323232",
  ticks_size = 0.3,
  ticks_pal = "#323232",
  bg_plot_pal = "#F1F3F5",
  bg_panel_pal = "#FEFEFE",
  bg_legend_key_pal = "plot",
  grid_h = FALSE,
  grid_v = FALSE,
  grid_pal = "#D3D3D3",
  grid_size = 0.2,
  facet_gap_size = 1.5,
  void = FALSE
)
}
\arguments{
\item{family}{The font family for all text to use. Defaults to "".}

\item{title_pal}{The colour palette for the title family. Defaults to "#000000".}

\item{title_family}{The font family for the title. If NULL, inherits from family argument.}

\item{title_size}{The size of the title family. Defaults to 11.}

\item{title_face}{The font style of the title family. Defaults to "bold".}

\item{subtitle_family}{The font family for the subtitle. If NULL, inherits from family argument.}

\item{subtitle_pal}{The colour palette for the subtitle family. Defaults to "#323232".}

\item{subtitle_size}{The size of the subtitle family. Defaults to 10.}

\item{subtitle_face}{The font style of the subtitle family. Defaults to "plain".}

\item{body_family}{The font family for all text other than the title, subtitle and caption. If NULL, inherits from family argument.}

\item{body_pal}{The colour palette for all text other than the title, subtitle or caption. Defaults to "#323232".}

\item{body_size}{The size of all text other than the title, subtitle and caption. Defaults to 10.}

\item{body_face}{The font style of all text other than the title, subtitle or caption. Defaults to "plain".}

\item{caption_family}{The font family for the caption. If NULL, inherits from family argument.}

\item{caption_pal}{The colour palette for the caption. Defaults to "#7F7F7F".}

\item{caption_size}{The size of the caption. Defaults to 9.}

\item{caption_face}{The font style of the caption. Defaults to "plain".}

\item{axis_size}{The size of the axis. Defaults to 0.3.}

\item{axis_pal}{The colour palette for the axis. Defaults to "#323232".}

\item{ticks_size}{The size of the ticks. Defaults to 0.3.}

\item{ticks_pal}{The colour palette for the ticks. Defaults to "#323232".}

\item{bg_plot_pal}{The colour palette for the plot background colour.}

\item{bg_panel_pal}{The colour palette for the panel background colour.}

\item{bg_legend_key_pal}{The colour palette for the legend key. Can also use special values of "plot" and "panel".}

\item{grid_h}{TRUE or FALSE of whether to show hotizontal gridlines. Defaults to FALSE.}

\item{grid_v}{TRUE or FALSE of whether to show vertical gridlines. Defaults to FALSE.}

\item{grid_pal}{The colour palette for the vertical major gridlines. Defaults to "#D3D3D3".}

\item{grid_size}{The size of the vertical major gridlines. Defaults to 0.2.}

\item{facet_gap_size}{The size of the spacing between facet panels in units of "lines". Defaults to 1.5.}

\item{void}{TRUE or FALSE of whether to remove axis lines, ticks and x and y titles and labels.}
}
\value{
A ggplot theme.
}
\description{
Quick theme for a ggplot visualisation.
}
