% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_blanket.R
\name{set_blanket}
\alias{set_blanket}
\title{Set a style}
\usage{
set_blanket(
  mode = light_mode_r(),
  geom_colour = "#357ba2",
  annotate_colour = "#121b24",
  annotate_linewidth = 0.33,
  annotate_family = "",
  annotate_size = 3.88,
  col_palette_d = jumble,
  col_palette_na_d = "#cdc5bfff",
  col_palette_c = viridisLite::mako(n = 9, direction = -1),
  col_palette_na_c = "#988f88ff",
  col_palette_o = scales::pal_viridis(option = "G", direction = -1),
  col_palette_na_o = "#988f88ff",
  theme = light_mode_r(orientation = "x"),
  ...
)
}
\arguments{
\item{mode}{A \verb{*_mode_*}. E.g. \code{\link[=light_mode_t]{light_mode_t()}}, \code{\link[=grey_mode_r]{grey_mode_r()}}, or \code{\link[=dark_mode_r]{dark_mode_r()}}.}

\item{geom_colour}{A hex colour (and fill) for most geoms. Fill inherits from this colour. Defaults to \code{blue}.}

\item{annotate_colour}{A hex colour (and fill) for other geoms commonly used for annotation (i.e. \verb{*_hline}/\verb{*_vline}/\verb{*_abline} and \verb{*_curve}). Defaults to "#121b24" (i.e. \code{lightness[1]}).}

\item{annotate_linewidth}{A linewidth for \verb{*_hline}/\verb{*_vline}/\verb{*_abline} and \verb{*_curve}. Defaults to 0.33.}

\item{annotate_family}{A family for \verb{*_text} and \verb{*_label}. Defaults to ""}

\item{annotate_size}{A size for \verb{*_text} and \verb{*_label}. Defaults to 3.88.}

\item{col_palette_d}{For a discrete scale, a character vector of hex codes (or names) for the \code{col_palette}.}

\item{col_palette_na_d}{For a discrete scale, a hex code or name for the \code{col_palette_na}.}

\item{col_palette_c}{For a continuous scale, a character vector of hex codes (or names) for the \code{col_palette}.}

\item{col_palette_na_c}{For a continuous scale, a hex code or name for the \code{col_palette_na}.}

\item{col_palette_o}{For an ordinal scale, a \verb{scales::pal_*()} function for the \code{col_palette}.}

\item{col_palette_na_o}{For an ordinal scale, a hex code or name for the \code{col_palette_na}.}

\item{theme}{A ggplot2 theme to be \code{+}-ed on unmodified to \verb{gg_*} functions. Note, \code{mode} takes precedence, unless \code{mode = NULL}.}

\item{...}{Provided to support trailing commas only.}
}
\value{
A globally set style.
}
\description{
Set a style by setting a mode, a series of geom and annotate aesthetic defaults, and a col_palette for discrete and continuous scales.
}
\examples{
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket(
  mode = dark_mode_r(),
  geom_colour = orange,
  annotate_colour = darkness[1],
)

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks = scales::breaks_pretty(3),
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.25), y = I(0.75), label = "Here")

penguins |>
  gg_histogram(
    x = flipper_length_mm,
    x_breaks = scales::breaks_pretty(3),
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.75), y = I(0.75), label = "Here")

}
