% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-waffle.R
\name{stat_waffle}
\alias{stat_waffle}
\alias{waffle}
\alias{geom_waffle}
\alias{geom_waffle0}
\title{stat_brick}
\usage{
stat_waffle(
  mapping = NULL,
  data = NULL,
  geom = "rect",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  bricks_per_layer = 4,
  type = "ordered",
  gap = NULL,
  width = 0.9,
  ...
)

geom_waffle(
  mapping = NULL,
  data = NULL,
  stat = "waffle",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  bricks_per_layer = 4,
  type = "ordered",
  gap = NULL,
  width = 0.9,
  ...
)

geom_waffle0(
  mapping = NULL,
  data = NULL,
  stat = "waffle",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  bricks_per_layer = 4,
  type = "ordered",
  gap = 0,
  width = 0.9,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Geom}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE} removes \code{NA}s from the data.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{bricks_per_layer}{The number of bricks per layer. Default 4.}

\item{type}{The type of fill ordering. one of 'ordered', 'random' or 'soft_random', Default 'ordered'}

\item{gap}{The space between bricks.}

\item{width}{Column width. Default \code{0.9}.}

\item{...}{Dots.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}
}
\value{
ggplot object
}
\description{
Creates a 'waffle' style chart with the aesthetic of a brick wall. Usage is
similar to \code{geom_col} where you supply counts as the height of the bar. Each
whole brick represents 1 unit. Two half bricks equal one whole brick. Where
the count exceeds the number of brick layers, the number of bricks is scaled
to retain the brick wall aesthetic.
}
\section{Aesthetics}{

\code{geom_waffle()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item{\strong{x}}
\item{\strong{y}}
\item{alpha}
\item{colour}
\item{fill}
\item{group}
\item{linetype}
\item{linewidth}
}
}

\examples{
library(ggplot2)
library(dplyr)
mpg \%>\%
  count(class, drv) \%>\%
  ggplot() +
  geom_waffle(aes(class, n, fill = drv)) +
  coord_waffle()
}
