% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbump.R
\name{geom_sigmoid}
\alias{geom_sigmoid}
\title{geom_sigmoid

Creates a ggplot that makes a smooth rank over time. To change the `smooth`
argument you need to put it outside of the `aes` of the geom.
Uses the x, xend, y and yend aestethics. Make sure each sigmoid curve is its own group.}
\usage{
geom_sigmoid(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  smooth = 8,
  direction = "x",
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{provide you own mapping. both x, xend, y and yend need to be numeric.}

\item{data}{provide you own data}

\item{geom}{xhange geom}

\item{position}{change position}

\item{na.rm}{remove missing values}

\item{show.legend}{show legend in plot}

\item{smooth}{how much smooth should the curve have? More means steeper curve.}

\item{direction}{the character x or y depending of smoothing direction}

\item{inherit.aes}{should the geom inherits aestethics}

\item{...}{other arguments to be passed to the geom}
}
\value{
ggplot layer
}
\description{
geom_sigmoid

Creates a ggplot that makes a smooth rank over time. To change the `smooth`
argument you need to put it outside of the `aes` of the geom.
Uses the x, xend, y and yend aestethics. Make sure each sigmoid curve is its own group.
}
\examples{
library(ggplot2)
df <- data.frame(x = 1:6,
       y = 5:10,
       xend = 7,
       yend = -3:2)

ggplot(df, aes(x = x, xend = xend, y = y, yend = yend, color = factor(x))) +
  geom_sigmoid()

}
