% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_early.R
\name{get_depth}
\alias{get_depth}
\title{Function to calculate hierarchy depth in lavaan models}
\usage{
get_depth(x, model, depth = 0L, max_depth = 20)
}
\arguments{
\item{x}{character vector of variables in a lavaan model}

\item{model}{character, lavaan fit object, or lavaan parameter table}

\item{depth}{initial depth}

\item{max_depth}{max depth at which to stop (prevents infinite loops for non-recursive models)}
}
\value{
integer
}
\description{
Function to calculate hierarchy depth in lavaan models
}
\examples{
model <- "X =~ X1 + X2"
get_depth("X", model = model)
get_depth("X1", model = model)
}
