% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_dotsinterval.R, R/stat_dotsinterval.R
\name{geom_dotsinterval}
\alias{geom_dotsinterval}
\alias{geom_dots}
\alias{stat_dotsinterval}
\alias{stat_dots}
\alias{stat_dist_dotsinterval}
\alias{stat_dist_dots}
\title{Automatic dotplots, dots + intervals, and quantile dotplots (ggplot geom)}
\usage{
geom_dotsinterval(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  dotsize = 1,
  stackratio = 1,
  binwidth = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_dots(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_dotsinterval(
  mapping = NULL,
  data = NULL,
  geom = "dotsinterval",
  position = "identity",
  ...,
  quantiles = NA,
  point_interval = median_qi,
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE
)

stat_dots(
  mapping = NULL,
  data = NULL,
  geom = "dots",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_dist_dotsinterval(
  mapping = NULL,
  data = NULL,
  geom = "dotsinterval",
  position = "identity",
  ...,
  quantiles = 100,
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE
)

stat_dist_dots(
  mapping = NULL,
  data = NULL,
  geom = "dots",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{
  Arguments passed on to \code{\link[=geom_slabinterval]{geom_slabinterval}}
  \describe{
    \item{\code{side}}{Which side to draw the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}
    \item{\code{scale}}{What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}
    \item{\code{orientation}}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}
    \item{\code{justification}}{Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to
\code{0.5}.}
    \item{\code{normalize}}{How to normalize heights of functions input to the \code{thickness} aesthetic. If \code{"all"}
(the default), normalize so that the maximum height across all data is \code{1}; if \code{"panels"}, normalize within
panels so that the maximum height in each panel is \code{1}; if \code{"xy"}, normalize within
the x/y axis opposite the \code{orientation} of this geom so that the maximum height at each value of the
opposite axis is \code{1}; if \code{"groups"}, normalize within values of the opposite axis and within
groups so that the maximum height in each group is \code{1}; if \code{"none"}, values are taken as is with no
normalization (this should probably only be used with functions whose values are in [0,1], such as CDFs).}
    \item{\code{interval_size_domain}}{The minimum and maximum of the values of the size aesthetic that will be translated into actual
sizes for intervals drawn according to \code{interval_size_range} (see the documentation for that argument.)}
    \item{\code{interval_size_range}}{This geom scales the raw size aesthetic values when drawing interval and point sizes, as
they tend to be too thick when using the default settings of \code{\link[=scale_size_continuous]{scale_size_continuous()}}, which give sizes
with a range of \code{c(1, 6)}. The \code{interval_size_domain} value indicates the input domain of raw size values
(typically this should be equal to the value of the \code{range} argument of the \code{\link[=scale_size_continuous]{scale_size_continuous()}}
function), and \code{interval_size_range} indicates the desired output range of the size values (the min and max of
the actual sizes used to draw intervals).}
    \item{\code{fatten_point}}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest interval line. If you wish to specify point sizes directly, you can also use the \code{point_size}
aesthetic and \code{\link[=scale_point_size_continuous]{scale_point_size_continuous()}} or \code{\link[=scale_point_size_discrete]{scale_point_size_discrete()}}; sizes
specified with that aesthetic will not be adjusted using \code{fatten_point}.}
    \item{\code{show_slab}}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}
    \item{\code{show_point}}{Should the point portion of the geom be drawn? Default \code{TRUE}.}
    \item{\code{show_interval}}{Should the interval portion of the geom be drawn? Default \code{TRUE}.}
  }}

\item{dotsize}{The size of the dots relative to the bin width. The default, \code{1}, makes dots be just about as
wide as the bin width.}

\item{stackratio}{The distance between the center of the dots in the same stack relative to the bin height. The
default, \code{1}, makes dots in the same stack just touch each other.}

\item{binwidth}{The bin width to use for drawing the dotplots. The default value, \code{NA}, will dynamically select
a bin width based on the size of the plot when drawn.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{quantiles}{For the \code{stat_} and \code{stat_dist_} stats, setting this to a value other than \code{NA}
will produce a quantile dotplot: that is, a dotplot of quantiles from the sample (for \code{stat_}) or a dotplot
of quantiles from the distribution (for \code{stat_dist_}). The value of \code{quantiles} determines the number
of quantiles to plot. See Kay et al. (2016) and Fernandes et al. (2018) for more information on quantile dotplots.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}
}
\value{
A \link[ggplot2:Geom]{ggplot2::Geom} or \link[ggplot2:Stat]{ggplot2::Stat} representing a dotplot or combined dotplot+interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Geoms and stats for creating dotplots that automatically determines a bin width that
ensures the plot fits within the available space. Also ensures dots do not overlap, and allows
generation of quantile dotplots using the \code{quantiles} argument to \code{stat_dotsinterval}/\code{stat_dots}
and \code{stat_dist_dotsinterval}/\code{stat_dist_dots}. Generally follows the naming scheme and
arguments of the \code{\link[=geom_slabinterval]{geom_slabinterval()}} and \code{\link[=stat_slabinterval]{stat_slabinterval()}} family of
geoms and stats.
}
\details{
The dots geoms are similar to \code{\link[=geom_dotplot]{geom_dotplot()}} but with a number of differences:

\itemize{
\item Dots geoms act like slabs in \code{\link[=geom_slabinterval]{geom_slabinterval()}} and can be given x positions (or y positions when
in a horizontal orientation).
\item Given the available space to lay out dots, the dots geoms will automatically determine how many bins to
use to fit the available space.
\item Dots geoms use a dynamic layout algorithm that lays out dots from the center out if the input data are
symmetrical, guaranteeing that symmetrical data results in a symmetrical plot. The layout algorithm also prevents
dots from overlapping each other.
\item The shape of the dots in a in these geoms can be changed using the \code{slab_shape} aesthetic (when using the
\code{dotsinterval} family) or the \code{shape} or \code{slab_shape} aesthetic (when using the \code{dots} family)
}

The \code{stat_...} and \code{stat_dist_...} versions of the stats when used with the \code{quantiles} argument
are particularly useful for constructing quantile dotplots, which can be an effective way to communicate uncertainty
using a frequency framing that may be easier for laypeople to understand (Kay et al. 2016, Fernandes et al. 2018).
}
\section{Aesthetics}{

These stats support the following aesthetics:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{thickness}
\item \code{size}
\item \code{group}
}
In addition, in their default configuration (paired with \code{\link[=geom_dotsinterval]{geom_dotsinterval()}}) the following aesthetics are supported by the underlying geom:
\itemize{
\item \code{slab_shape}
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{y}
\item \code{ymin}
\item \code{ymax}
\item \code{x}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

data(RankCorr_u_tau, package = "ggdist")

# orientation is detected automatically based on
# which axis is discrete

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau)) +
  geom_dots()

RankCorr_u_tau \%>\%
  ggplot(aes(y = u_tau)) +
  geom_dots()

# stat_dots can summarize quantiles, creating quantile dotplots

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau, y = i)) +
  stat_dots(quantiles = 100)

# color and fill aesthetics can be mapped within the geom
# dotsinterval adds an interval

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau, y = i, fill = stat(x > 6))) +
  stat_dotsinterval(quantiles = 100)

}
\references{
Kay, M., Kola, T., Hullman, J. R., & Munson, S. A. (2016). When (ish) is My Bus? User-centered Visualizations
of Uncertainty in Everyday, Mobile Predictive Systems. \emph{Conference on Human Factors
in Computing Systems - CHI '16}, 5092--5103. \doi{10.1145/2858036.2858558}.

Fernandes, M., Walls, L., Munson, S., Hullman, J., & Kay, M. (2018). Uncertainty Displays Using Quantile Dotplots
or CDFs Improve Transit Decision-Making. \emph{Conference on Human Factors in Computing Systems - CHI '18}.
\doi{10.1145/3173574.3173718}.
}
\seealso{
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} for families of other
stats built on top of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.
See \code{vignette("slabinterval")} for a variety of examples of use.
}
\author{
Matthew Kay
}
