% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning_methods.R
\name{find_dotplot_binwidth}
\alias{find_dotplot_binwidth}
\title{Dynamically select a good bin width for a dotplot}
\usage{
find_dotplot_binwidth(x, maxheight, heightratio = 1)
}
\arguments{
\item{x}{numeric vector of values}

\item{maxheight}{maximum height of the dotplot}

\item{heightratio}{ratio of bin width to dot height}
}
\value{
A suitable bin width such that a dotplot created with this bin width
and \code{heightratio} should have its tallest bin be less than or equal to \code{maxheight}.
}
\description{
Searches for a nice-looking bin width to use to draw a dotplot such that
the height of the dotplot fits within a given space (\code{maxheight}).
}
\details{
This dynamic bin selection algorithm uses a binary search over the number of
bins to find a bin width such that if the input data (\code{x}) is binned
using a Wilkinson-style dotplot algorithm the height of the tallest bin
will be less than \code{maxheight}.

This algorithm is used by \code{geom_dotsinterval()} (and its variants) to automatically
select bin widths. Unless you are manually implementing you own dotplot \code{\link{grob}}
or \code{geom}, you probably do not need to use this function directly
}
\examples{

library(dplyr)
library(ggplot2)

x = qnorm(ppoints(20))
binwidth = find_dotplot_binwidth(x, maxheight = 4, heightratio = 1)
binwidth

bin_df = bin_dots(x = x, y = 0, binwidth = binwidth, heightratio = 1)
bin_df

# we can manually plot the binning above, though this is only recommended
# if you are using find_dotplot_binwidth() and bin_dots() to build your own
# grob. For practical use it is much easier to use geom_dots(), which will
# automatically select good bin widths for you (and which uses
# find_dotplot_binwidth() and bin_dots() internally)
bin_df \%>\%
  ggplot(aes(x = x, y = y)) +
  geom_point(size = 4) +
  coord_fixed()

}
\seealso{
\code{\link[=bin_dots]{bin_dots()}} for an algorithm can bin dots using bin widths selected
by this function; \code{\link[=geom_dotsinterval]{geom_dotsinterval()}} for geometries that use
these algorithms to create dotplots.
}
