% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_interval.R
\name{geom_interval}
\alias{geom_interval}
\title{Multiple uncertainty interval plots (ggplot geom)}
\usage{
geom_interval(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  orientation = NA,
  interval_size_range = c(1, 6),
  show_slab = FALSE,
  show_point = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{The position adjustment to use for overlapping points on this layer. Setting this equal to
\code{"dodge"} can be useful if you have overlapping intervals.}

\item{...}{
  Arguments passed on to \code{\link[=geom_slabinterval]{geom_slabinterval}}
  \describe{
    \item{\code{normalize}}{How to normalize heights of functions input to the \code{thickness} aesthetic. If \code{"all"}
(the default), normalize so that the maximum height across all data is \code{1}; if \code{"panels"}, normalize within
panels so that the maximum height in each panel is \code{1}; if \code{"xy"}, normalize within
the x/y axis opposite the \code{orientation} of this geom so that the maximum height at each value of the
opposite axis is \code{1}; if \code{"groups"}, normalize within values of the opposite axis and within
groups so that the maximum height in each group is \code{1}; if \code{"none"}, values are taken as is with no
normalization (this should probably only be used with functions whose values are in [0,1], such as CDFs).}
    \item{\code{fill_type}}{What type of fill to use when the fill color or alpha varies within a slab. The default,
\code{"segments"}, breaks up the slab geometry into segments for each unique combination of fill color and
alpha value. This approach is supported by all graphics devices and works well for sharp cutoff values,
but can result in ugly results if a large number of unique fill colors are being used (as in gradients,
like in \code{\link[=stat_gradientinterval]{stat_gradientinterval()}}). When \code{fill_type == "gradient"}, a \code{linearGradient()} is used to
create a smooth gradient fill. This works well for large numbers of unique fill colors, but requires
R > 4.1 and is not yet supported on all graphics devices.}
    \item{\code{interval_size_domain}}{The minimum and maximum of the values of the size aesthetic that will be translated into actual
sizes for intervals drawn according to \code{interval_size_range} (see the documentation for that argument.)}
    \item{\code{fatten_point}}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest interval line. If you wish to specify point sizes directly, you can also use the \code{point_size}
aesthetic and \code{\link[=scale_point_size_continuous]{scale_point_size_continuous()}} or \code{\link[=scale_point_size_discrete]{scale_point_size_discrete()}}; sizes
specified with that aesthetic will not be adjusted using \code{fatten_point}.}
    \item{\code{show_interval}}{Should the interval portion of the geom be drawn? Default \code{TRUE}.}
    \item{\code{na.rm}}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}
    \item{\code{show.legend}}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
  }}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{interval_size_range}{(Deprecated). This geom scales the raw size aesthetic values when drawing interval and point sizes, as
they tend to be too thick when using the default settings of \code{\link[=scale_size_continuous]{scale_size_continuous()}}, which give sizes
with a range of \code{c(1, 6)}. The \code{interval_size_domain} value indicates the input domain of raw size values
(typically this should be equal to the value of the \code{range} argument of the \code{\link[=scale_size_continuous]{scale_size_continuous()}}
function), and \code{interval_size_range} indicates the desired output range of the size values (the min and max of
the actual sizes used to draw intervals). Most of the time it is not recommended to change the value of this argument,
as it may result in strange scaling of legends; this argument is a holdover from earlier versions
that did not have size aesthetics targeting the point and interval separately. If you want to adjust the
size of the interval or points separately, you can instead use the \code{interval_size} or \code{point_size}
aesthetics; see \link{scales}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{show_point}{Should the point portion of the geom be drawn? Default \code{TRUE}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} representing a multiple interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Multiple interval geoms with default aesthetics
designed for use with output from \code{\link[=point_interval]{point_interval()}}.
Wrapper around \code{\link[=geom_slabinterval]{geom_slabinterval()}}.
}
\details{
These geoms are wrappers around \code{\link[=geom_slabinterval]{geom_slabinterval()}} with defaults designed to produce
multiple interval plots. These geoms set some default aesthetics equal
to the \code{.lower}, \code{.upper}, and \code{.width} columns generated by the \code{point_interval} family
of functions, making them often more convenient than vanilla \code{\link[=geom_linerange]{geom_linerange()}}
when used with functions like \code{\link[=median_qi]{median_qi()}}, \code{\link[=mean_qi]{mean_qi()}},
\code{\link[=mode_hdi]{mode_hdi()}}, etc.

Specifically, \code{geom_interval} acts as if its default aesthetics are
\code{aes(color = forcats::fct_rev(ordered(.width)))}.
}
\section{Aesthetics}{

The slab+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{slab}, the \strong{point}, and
the \strong{interval}.

\strong{Positional aesthetics}
\itemize{
\item \code{x}: x position of the geometry
\item \code{y}: y position of the geometry
}
\strong{Slab-specific aesthetics}
\itemize{
\item \code{thickness}: The thickness of the slab at each \code{x} value (if \code{orientation = "horizontal"}) or
\code{y} value (if \code{orientation = "vertical"}) of the slab.
\item \code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).
\item \code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.
\item \code{justification}: Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to 0.5.
\item \code{datatype}: When using composite geoms directly without a \code{stat} (e.g. \code{\link[=geom_slabinterval]{geom_slabinterval()}}), \code{datatype} is used to
indicate which part of the geom a row in the data targets: rows with \code{datatype = "slab"} target the
slab portion of the geometry and rows with \code{datatype = "interval"} target the interval portion of
the geometry. This is set automatically when using ggdist \code{stat}s.
}
\strong{Interval-specific aesthetics}
\itemize{
\item \code{xmin}: Left end of the interval sub-geometry (if \code{orientation = "horizontal"}).
\item \code{xmax}: Right end of the interval sub-geometry (if \code{orientation = "horizontal"}).
\item \code{ymin}: Lower end of the interval sub-geometry (if \code{orientation = "vertical"}).
\item \code{ymax}: Upper end of the interval sub-geometry (if \code{orientation = "vertical"}).
}
\strong{Point-specific aesthetics}
\itemize{
\item \code{shape}: Shape type used to draw the \strong{point} sub-geometry.
}
\strong{Color aesthetics}
\itemize{
\item \code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.
\item \code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.
\item \code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.
\item \code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{scale_colour_ramp()} for examples.
\item \code{fill_ramp}: (or \code{fill_ramp}) A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{scale_fill_ramp()} for examples.
}
\strong{Line aesthetics}
\itemize{
\item \code{size}: Width of the outline around the \strong{slab} (if visible). Also determines the width of
the line used to draw the \strong{interval} and the size of the \strong{point}, but raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{slab_size},
\code{interval_size}, or \code{point_size} aesthetics (below) to set sub-geometry line widths separately
(note that when size is set directly using the override aesthetics, interval and point
sizes are not affected by \code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}).
\item \code{stroke}: Width of the outline around the \strong{point} sub-geometry.
\item \code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.
}
\strong{Slab-specific color/line override aesthetics}
\itemize{
\item \code{slab_fill}: Override for \code{fill}: the fill color of the slab.
\item \code{slab_colour}: (or \code{slab_color}) Override for \code{colour}/\code{color}: the outline color of the slab.
\item \code{slab_alpha}: Override for \code{alpha}: the opacity of the slab.
\item \code{slab_size}: Override for \code{size}: the width of the outline of the slab.
\item \code{slab_linetype}: Override for \code{linetype}: the line type of the outline of the slab.
}
\strong{Interval-specific color/line override aesthetics}
\itemize{
\item \code{interval_colour}: (or \code{interval_color}) Override for \code{colour}/\code{color}: the color of the interval.
\item \code{interval_alpha}: Override for \code{alpha}: the opacity of the interval.
\item \code{interval_size}: Override for \code{size}: the line width of the interval.
\item \code{interval_linetype}: Override for \code{linetype}: the line type of the interval.
}
\strong{Point-specific color/line override aesthetics}
\itemize{
\item \code{point_fill}: Override for \code{fill}: the fill color of the point.
\item \code{point_colour}: (or \code{point_color}) Override for \code{colour}/\code{color}: the outline color of the point.
\item \code{point_alpha}: Override for \code{alpha}: the opacity of the point.
\item \code{point_size}: Override for \code{size}: the size of the point.
}
\strong{Other aesthetics} (these work as in standard \code{geom}s)
\itemize{
\item \code{width}
\item \code{height}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

theme_set(theme_ggdist())

data(RankCorr_u_tau, package = "ggdist")

# orientation is detected automatically based on
# use of xmin/xmax or ymin/ymax

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(y = i, x = u_tau, xmin = .lower, xmax = .upper)) +
  geom_interval() +
  scale_color_brewer()

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(x = i, y = u_tau, ymin = .lower, ymax = .upper)) +
  geom_interval() +
  scale_color_brewer()

}
\seealso{
See \code{\link[=stat_interval]{stat_interval()}} for the stat version, intended
for use on samples from a distribution.
See \code{\link[=geom_interval]{geom_interval()}} for a similar geom intended for intervals without
point summaries.
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} for a variety of other
stats that combine intervals with densities and CDFs.
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geom that these geoms wrap. All parameters of that geom are
available to these geoms.
}
\author{
Matthew Kay
}
