% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{\%?\%}
\alias{\%?\%}
\title{If true then object else null}
\usage{
lhs \%?\% rhs
}
\arguments{
\item{lhs}{logical scalar.}

\item{rhs}{object to return if \code{lhs} is \code{TRUE}.}
}
\value{
object on \code{rhs} or \code{NULL}
}
\description{
If true then object else null
}
\details{
This is primarily used in conjuction with the \code{\%:\%} operator. See
examples.
}
\examples{
\donttest{
`\%:\%` <- ggdistribute:::`\%:\%`
`\%?\%` <- ggdistribute:::`\%?\%`

TRUE  \%?\% 1 \%:\% 0  #> 1
FALSE \%?\% 1 \%:\% 0  #> 0

x <- 0

# expression returns whatever objects are wrapped in between \%:\%
(x == 0) \%?\% "y" \%:\% "n"
(x == 1) \%?\% c("y", "yes") \%:\% c("n", "No", "false")

# ERROR: The \%?\% operator captured only 0, which is not logical.
# x == 0 \%?\% "y" \%:\% "n"

# ERROR: The TRUE slot cannot return NULL because NULL is used to
# decide what to return in \%:\%
#   `TRUE \%?\% NULL` and `FALSE \%?\% obj` would both return NULL.
# (x == 0) \%?\% NULL \%:\% "n"
}
}
