% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_plotting.R
\name{plot_dist}
\alias{plot_dist}
\title{Plot Cell Density}
\usage{
plot_dist(mdi, xlim = c(0, Inf), ylim = c(0, Inf), main = NULL,
  save.dat = FALSE, ...)
}
\arguments{
\item{mdi}{a model data instance, a data frame class created by model.dmc}

\item{xlim}{the range on the x axis. Default is (0, Inf)}

\item{ylim}{the range on the y axix. Default is (0, Inf)}

\item{main}{a string for the main title}

\item{save.dat}{save plot data, instead of plotting}

\item{...}{other arguments}
}
\description{
\code{plot.dist} plots the distributions of correct and error RTs and
reports accuracy rate.
}
\examples{
model <- model.dmc(
  p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
  constants = c(st0=0,d=0),
  match.map = list(M=list(s1="r1",s2="r2")),
  factors   = list(S=c("s1","s2")),
  responses = c("r1","r2"),
  type      = "rd")

pVec <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat1 <- simulate(model, nsim=1e2, p.vector=pVec)
mdi1 <- data.model.dmc(dat1, model)
plot_dist(mdi1)
}
\keyword{plot_dist}

