# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

pnormP <- function(x, mean = 0, sd = 1, lt = TRUE, lg = FALSE) {
    .Call('_ggdmc_pnormP', PACKAGE = 'ggdmc', x, mean, sd, lt, lg)
}

dnormP <- function(x, mean = 0, sd = 1, lg = FALSE) {
    .Call('_ggdmc_dnormP', PACKAGE = 'ggdmc', x, mean, sd, lg)
}

#' @rdname removet0
#' @export
remove_t0 <- function(x, t0) {
    .Call('_ggdmc_remove_t0', PACKAGE = 'ggdmc', x, t0)
}

GetTime2Finish <- function(drifts, A, b, t0, st0, nmean_v, n) {
    .Call('_ggdmc_GetTime2Finish', PACKAGE = 'ggdmc', drifts, A, b, t0, st0, nmean_v, n)
}

fptcdf <- function(rt, A, b, mean_v, sd_v, t0, posdrift) {
    .Call('_ggdmc_fptcdf', PACKAGE = 'ggdmc', rt, A, b, mean_v, sd_v, t0, posdrift)
}

fptpdf <- function(rt, A, b, mean_v, sd_v, t0, posdrift) {
    .Call('_ggdmc_fptpdf', PACKAGE = 'ggdmc', rt, A, b, mean_v, sd_v, t0, posdrift)
}

n1PDFfixedt0 <- function(rt, A, b, mean_v, sd_v, t0, posdrift) {
    .Call('_ggdmc_n1PDFfixedt0', PACKAGE = 'ggdmc', rt, A, b, mean_v, sd_v, t0, posdrift)
}

n1PDFfixedt0_pda <- function(rt, A, b, mean_v, sd_v, t0, n, h, debug) {
    .Call('_ggdmc_n1PDFfixedt0_pda', PACKAGE = 'ggdmc', rt, A, b, mean_v, sd_v, t0, n, h, debug)
}

#' Likelihood function for correlated accumulator model
#'
#' Calculate first node probability densities of the correlated accumulator
#' model
#'
#' @param x response time vector
#' @param A start point variability
#' @param b threshold
#' @param t0 nondecision time
#' @param mean_v mean drift rate vector
#' @param sd_v standard deviation of the drift rates
#' @param st0 nondecision time variability
#' @param corr_v correlation among accumulators
#' @param n number of simulations
#' @param h kernel bandwidth
#' @param debug debugging?
#'
#' @export
n1PDF_cnorm <- function(x, A, b, t0, mean_v, sd_v, st0, corr_v, n, h, debug = FALSE) {
    .Call('_ggdmc_n1PDF_cnorm', PACKAGE = 'ggdmc', x, A, b, t0, mean_v, sd_v, st0, corr_v, n, h, debug)
}

#' A Rcpp connection to the GPU-based LBA n1PDF in ppda package
#'
#' This is an Rcpp function calling a \code{n1PDF_gpu} function defined
#' in the global environment, which connects to an interanl ppda
#' simulated-based LBA density function.
#'
#' @param x response time vector
#' @param A start point variability
#' @param b threshold
#' @param mean_v mean drift rate vector
#' @param sd_v standard deviation of the drift rates
#' @param t0 nondecision time
#' @param n number of simulations
#' @param nthread thread number to launch in GPU
#' @param gpuid which gpu card to use, starting from 0.
#' @param bw kernel bandwidth
#' @param debug debugging?
#' @export
n1PDF_gpu <- function(x, A, b, mean_v, sd_v, t0, n, nthread, gpuid, bw, debug) {
    .Call('_ggdmc_n1PDF_gpu', PACKAGE = 'ggdmc', x, A, b, mean_v, sd_v, t0, n, nthread, gpuid, bw, debug)
}

#' A Rcpp connection to the GPU-based PLBA n1PDF type 0 and type 1
#'
#' This is an Rcpp function calling a \code{n1PDF_plba0_gpu} function defined
#' in the global environment, which connect to an interanl ppda simulated-based
#' PLBA density function.
#'
#' @param x response time vector
#' @param A start point variability
#' @param b threshold
#' @param mean_v mean drift rate vector for the first piece of evidence
#' accumulation.
#' @param sd_v standard deviation of the drift rates
#' @param t0 nondecision time
#' @param mean_w mean drift rate vector for the second piece of evidence
#' accumulation.
#' @param rD rate delay time (s)
#' @param swt switch time (s)
#' @param n number of simulations
#' @param nthread thread number to launch in GPU
#' @param gpuid which gpu card to use, starting from 0.
#' @param bw kernel bandwidth
#' @param debug debugging?
#' @export
n1PDF_plba0_gpu <- function(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread, gpuid, bw, debug) {
    .Call('_ggdmc_n1PDF_plba0_gpu', PACKAGE = 'ggdmc', x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread, gpuid, bw, debug)
}

#' @rdname n1PDF_plba0_gpu
#' @export
n1PDF_plba1_gpu <- function(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread, gpuid, bw, debug) {
    .Call('_ggdmc_n1PDF_plba1_gpu', PACKAGE = 'ggdmc', x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread, gpuid, bw, debug)
}

make_r <- function(drifts, A, b, t0, st0, return_ttf, debug = FALSE) {
    .Call('_ggdmc_make_r', PACKAGE = 'ggdmc', drifts, A, b, t0, st0, return_ttf, debug)
}

make_v <- function(n, mean_v, sd_v, posdrift = TRUE) {
    .Call('_ggdmc_make_v', PACKAGE = 'ggdmc', n, mean_v, sd_v, posdrift)
}

rlba_norm <- function(n, A, b, mean_v, sd_v, t0, st0, posdrift = TRUE, return_ttf = FALSE, debug = FALSE) {
    .Call('_ggdmc_rlba_norm', PACKAGE = 'ggdmc', n, A, b, mean_v, sd_v, t0, st0, posdrift, return_ttf, debug)
}

make_sigma <- function(nv, sd_v, corr_v) {
    .Call('_ggdmc_make_sigma', PACKAGE = 'ggdmc', nv, sd_v, corr_v)
}

#' Calculate Drift-diffusion Probability Density
#'
#' \code{g_minus} and \code{g_plus} implement A1 to A4 equations in Voss,
#' Rothermund, and Voss (2004). These equations calculate Ratcliff's
#' drift-diffusion model (1978). This source codes are derived from
#' Voss & Voss's fast-dm 30.2 in density.c.
#'
#' Two parallel functions \code{g_minus_parallel} and \code{g_plus_parallel},
#' using OpenMP libraries to do numerical integration. They resolve the
#' problem when high precision (> 10) is required.
#'
#' @param pVec a 9-element parameter (double) vector. The user has to follow
#' the sequence strictly. a, v, zr, d, sz, sv, t0, st0, RT, precision.
#' @references Voss, A., Rothermund, K., & Voss, J. (2004). Interpreting the
#' parameters of the diffusion model: A empirical validation
#' \emph{Memory and Cognition}, \bold{32(7)}, 1206--1220. \cr\cr
#' Ratcliff, R (1978). A theory of memory retrieval. \emph{Psychology Review},
#' \bold{85(2)}, 59--108.
#' @export
#' @examples
#' pvec1 <- c(a=2, v=2.5, zr=0.5, d=0, sz=0.3, sv=1, t0=0.3, st0=0,
#'            RT=.550, precision=2.5)
#' g_minus(pvec1) ## 0.04965882
#' g_plus(pvec1) ## 2.146265
#'
#' pvec2 <- c(a=2, v=2.5, zr=0.5, d=.2, sz=0.3, sv=1, t0=0.3, st0=.1,
#'            RT=.550, precision=2.5)
#'
#' g_minus(pvec2) ## 0.04194364
#' g_plus(pvec2)  ## 1.94957
#'
g_minus <- function(pVec) {
    .Call('_ggdmc_g_minus', PACKAGE = 'ggdmc', pVec)
}

#' @rdname g_minus
#' @export
g_plus <- function(pVec) {
    .Call('_ggdmc_g_plus', PACKAGE = 'ggdmc', pVec)
}

FlipResponse_norm <- function(parmat, n1mat, dim1, dim3, parnames, cell) {
    .Call('_ggdmc_FlipResponse_norm', PACKAGE = 'ggdmc', parmat, n1mat, dim1, dim3, parnames, cell)
}

#' Check parameter vector of DDM
#'
#' Check if all DDM parameters are within reasonable ragnes
#'
#' @param pVec a numeric vector storing the DDM parameters
#' @export
checkddm2 <- function(pVec) {
    .Call('_ggdmc_checkddm2', PACKAGE = 'ggdmc', pVec)
}

p_df <- function(pVec, cell, pnames, allpar, parnames, model, type, dim1, dim2, dim3, isr1, n1idx, n1order = TRUE) {
    .Call('_ggdmc_p_df', PACKAGE = 'ggdmc', pVec, cell, pnames, allpar, parnames, model, type, dim1, dim2, dim3, isr1, n1idx, n1order)
}

getbounds <- function(data) {
    .Call('_ggdmc_getbounds', PACKAGE = 'ggdmc', data)
}

density_rd <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, precision = 2.5) {
    .Call('_ggdmc_density_rd', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, precision)
}

density_norm <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, posdrift) {
    .Call('_ggdmc_density_norm', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, posdrift)
}

density_cnorm_pda <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, debug = FALSE) {
    .Call('_ggdmc_density_cnorm_pda', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, debug)
}

density_norm_pda <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, npda = 16384L, bw = .01, debug = FALSE) {
    .Call('_ggdmc_density_norm_pda', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, npda, bw, debug)
}

density_norm_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim = 16384L, bw = .01, gpuid = 0L, nthread = 32L, debug = FALSE) {
    .Call('_ggdmc_density_norm_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, gpuid, nthread, debug)
}

density_plba1 <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim = 16384L, bw = .01, ncore = 1L, debug = FALSE) {
    .Call('_ggdmc_density_plba1', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, ncore, debug)
}

density_plba0_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim = 16384L, bw = .01, ncore = 1L, gpuid = 0L, nthread = 32L, debug = FALSE) {
    .Call('_ggdmc_density_plba0_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, ncore, gpuid, nthread, debug)
}

density_plba1_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim = 16384L, bw = .01, ncore = 1L, gpuid = 0L, nthread = 32L, debug = FALSE) {
    .Call('_ggdmc_density_plba1_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, nsim, bw, ncore, gpuid, nthread, debug)
}

#' Calculate Summed, Log-likelihood of a Cognitive Model
#'
#' The function calculates log-likelihood for every trial.  The input must
#' be a data model instance.
#'
#' @param pVec a parameter vector
#' @param pnames a string vector storing the name of a parameter vector
#' @param allpar all parameters
#' @param parnames parameter names
#' @param model a model specification
#' @param type model type
#' @param dim1 first dimension of a model
#' @param dim2 second dimension of a model
#' @param dim3 third dimension of a model
#' @param n1idx n1 order index
#' @param ise an index vector storing if a cell is empty.
#' @param cellidx cell index
#' @param RT a RT vector
#' @param matchcell an index vector storing is the cell is a match response
#' @param isr1 is r1 index
#' @param posdrift a Boolean switch to enforce postive drift rate correction
#' @param nsim number of simulation
#' @param bw bandwidth
#' @param ncore number of parallel core
#' @param gpuid GPU card index on a multiple GPU machine
#' @param debug whether to print debugging information
#' for assuming drift rates are drawn from a normal distribution.
#' @return a double scalar
#' @examples
#' m1 <- BuildModel(
#'   p.map     = list(a = "1", v = "1", z = "1", d = "1", sz = "1", sv = "1",
#'               t0 = "1", st0 = "1"),
#'   constants = c(st0 = 0, d = 0),
#'   match.map = list(M = list(s1 = "r1", s2 = "r2")),
#'   factors   = list(S = c("s1", "s2")),
#'   responses = c("r1", "r2"),
#'   type      = "rd")
#'
#' p.vector <- c(a = 1, v = 1, z = 0.5, sz = 0.25, sv = 0.2, t0 = .15)
#'
#' ## Set up a model-data instance
#' dat <- simulate(m1, 128, ps = p.vector)
#' dmi <- BuildDMI(dat, m1)
#' ## sumloglike(p.vector, dmi)
#' ## [1] 0.3796048
#' @export
sumloglike <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, posdrift, nsim, bw, ncore, gpuid, debug) {
    .Call('_ggdmc_sumloglike', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, posdrift, nsim, bw, ncore, gpuid, debug)
}

profile_rd <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps) {
    .Call('_ggdmc_profile_rd', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps)
}

profile_norm <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, posdrift) {
    .Call('_ggdmc_profile_norm', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, posdrift)
}

profile_norm_pda <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw) {
    .Call('_ggdmc_profile_norm_pda', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw)
}

profile_cnorm_pda <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw) {
    .Call('_ggdmc_profile_cnorm_pda', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw)
}

profile_norm_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw) {
    .Call('_ggdmc_profile_norm_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw)
}

profile_plba1 <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw) {
    .Call('_ggdmc_profile_plba1', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw)
}

profile_plba1_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw, gpuid, nthread, debug) {
    .Call('_ggdmc_profile_plba1_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw, gpuid, nthread, debug)
}

profile_plba0_gpu <- function(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw, gpuid, nthread, debug) {
    .Call('_ggdmc_profile_plba0_gpu', PACKAGE = 'ggdmc', pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3, n1idx, ise, cellidx, RT, matchcell, isr1, pname, ps, nsim, bw, gpuid, nthread, debug)
}

#' Extract Start Posterior Sample
#'
#' Extract the theta's of the first MCMC iteration across chains and
#' participants. Note that the ps array in DMC is a nchain x nsubject x
#' nparameter array. Armadillo operates on slice (the third dimension), so
#' chain dimension has to be on slice.
#'
#' @param samples posterior samples
#' @return a nsubject x npar x nchain array
#' @export
GetTheta0 <- function(samples) {
    .Call('_ggdmc_GetTheta0', PACKAGE = 'ggdmc', samples)
}

sumloghprior <- function(location, scale, ldists, sdists, lp1, sp1, lp2, sp2, llower, slower, lupper, supper, llog, slog) {
    .Call('_ggdmc_sumloghprior', PACKAGE = 'ggdmc', location, scale, ldists, sdists, lp1, sp1, lp2, sp2, llower, slower, lupper, supper, llog, slog)
}

sumloghlike <- function(thetak, dists, p1, p2, lower, upper, islog) {
    .Call('_ggdmc_sumloghlike', PACKAGE = 'ggdmc', thetak, dists, p1, p2, lower, upper, islog)
}

StartIteration <- function(samples) {
    invisible(.Call('_ggdmc_StartIteration', PACKAGE = 'ggdmc', samples))
}

init_new <- function(nmc, pprior, data, rp, thin, nchain, ncore = 1L, debug = FALSE) {
    .Call('_ggdmc_init_new', PACKAGE = 'ggdmc', nmc, pprior, data, rp, thin, nchain, ncore, debug)
}

init_old <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_old', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

init_add <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_add', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

init_newnonhier <- function(nmc, data, pprior, rp, thin, nchain) {
    .Call('_ggdmc_init_newnonhier', PACKAGE = 'ggdmc', nmc, data, pprior, rp, thin, nchain)
}

init_oldnonhier <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_oldnonhier', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

init_addnonhier <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_addnonhier', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

init_newhier <- function(nmc, data, pprior, ppprior, rp, thin, nchain) {
    .Call('_ggdmc_init_newhier', PACKAGE = 'ggdmc', nmc, data, pprior, ppprior, rp, thin, nchain)
}

init_oldhier <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_oldhier', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

init_addhier <- function(nmc, samples, rp, thin) {
    .Call('_ggdmc_init_addhier', PACKAGE = 'ggdmc', nmc, samples, rp, thin)
}

#' Generate Random Choice RT Data from LNR Model
#'
#' Race among \code{nacc} accumulators, using log-normal race model
#'
#' @param n numbers of observation
#' @param meanlog a n_acc length vector or a n_acc x n matrix. mean
#' of the distribution on the log scale without default value
#' @param sdlog a n_acc length vector or a n_acc x n matrix. Standard
#' deviation of the distribution on the log scale without default value.
#' @param t0 a scalar, a vector of length number of accumulators or a
#' matrix with 1 row per accumulator, when start time differ on each trial
#' @param st0 range of non-decision time variability, must be a scalar, as the same
#' variability is assumed in a common encoding/production stage
#' @return a matrix
#' @examples
#' ## A simple demo
#' pmat <- matrix(c(-1, 0, 1, 1, .2, .2, 0, 0), 2)
#' set.seed(123)
#' dat0 <- rlnr(4, pmat[,1], pmat[,2], pmat[,3], pmat[1,4])
#' ##           [,1] [,2]
#' ## [1,] 0.4100361    0
#' ## [2,] 0.4922407    0
#' ## [3,] 1.7855260    1
#' ## [4,] 0.4822220    1
#' ##
#' ## Three accumulators
#' n <- 1e5
#' meanlog <- c(.5, .75, 1);
#' sdlog <- c(1,1,1)
#' t0 <- c(.2,1,1)
#' set.seed(123)
#' dat1 <- rlnr(n, meanlog, sdlog, t0)
#' table(dat1[,2])
#' hist(dat1[,1], breaks = "fd", main = "", xlab ="")
#'
#' ## t0 has one element only
#' t0 <- .2
#' set.seed(123)
#' dat2 <- rlnr(n, meanlog, sdlog, t0)
#' table(dat2[,2])
#' hist(dat2[,1], breaks = "fd", freq = FALSE, main = "", xlab ="")
#' ## check t0 noise
#' st0 <- 1
#' set.seed(123)
#' dat3 <- rlnr(n, meanlog, sdlog, t0, st0)
#' table(dat3[,2])
#' hist(dat3[,1], breaks = "fd", freq = FALSE, main = "", xlab ="")
#'
#' @export
rlnr <- function(n, meanlog, sdlog, t0, st0 = 0) {
    .Call('_ggdmc_rlnr', PACKAGE = 'ggdmc', n, meanlog, sdlog, t0, st0)
}

rlnrDF <- function(n, meanlog, sdlog, t0, st0 = 0) {
    .Call('_ggdmc_rlnrDF', PACKAGE = 'ggdmc', n, meanlog, sdlog, t0, st0)
}

n1PDFfixedt0_lnr1 <- function(x, meanlog, sdlog) {
    .Call('_ggdmc_n1PDFfixedt0_lnr1', PACKAGE = 'ggdmc', x, meanlog, sdlog)
}

n1PDFfixedt0_lnr2 <- function(x, meanlog, sdlog) {
    .Call('_ggdmc_n1PDFfixedt0_lnr2', PACKAGE = 'ggdmc', x, meanlog, sdlog)
}

#' Simulated likelihood functions for RT models
#'
#' CPU-based PDA
#'
#' @param x empirical data
#' @param RT simulated resposne times
#' @param n number of model simulations
#' @param h_in kernel bandwidth
#' @param debug debugging?
#' @return a vector
#' @export
spdf <- function(x, RT, n, h_in, debug = FALSE) {
    .Call('_ggdmc_spdf', PACKAGE = 'ggdmc', x, RT, n, h_in, debug)
}

#' @rdname rplba1R
#' @export
rplba0 <- function(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore = 1L, debug = FALSE) {
    .Call('_ggdmc_rplba0', PACKAGE = 'ggdmc', n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore, debug)
}

#' @rdname rplba1R
#' @export
rplba1 <- function(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore = 1L, debug = FALSE) {
    .Call('_ggdmc_rplba1', PACKAGE = 'ggdmc', n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore, debug)
}

#' @rdname rplba1R
#' @export
rplba2 <- function(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt, ncore = 1L, debug = FALSE) {
    .Call('_ggdmc_rplba2', PACKAGE = 'ggdmc', n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt, ncore, debug)
}

#' @rdname rplba1R
#' @export
rplba3 <- function(n, A, B, C, mean_v, mean_w, sd_v, sd_w, rD, tD, swt, t0) {
    .Call('_ggdmc_rplba3', PACKAGE = 'ggdmc', n, A, B, C, mean_v, mean_w, sd_v, sd_w, rD, tD, swt, t0)
}

#' @rdname rplba1R
#' @export
n1PDF_plba1 <- function(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, h, ncore, debug) {
    .Call('_ggdmc_n1PDF_plba1', PACKAGE = 'ggdmc', x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, h, ncore, debug)
}

#' @rdname rplba1R
#' @export
n1PDF_plba2 <- function(x, A, b, mean_v, sd_v, t0, mean_w, sd_w, rD, swt, n, h, ncore, debug) {
    .Call('_ggdmc_n1PDF_plba2', PACKAGE = 'ggdmc', x, A, b, mean_v, sd_v, t0, mean_w, sd_w, rD, swt, n, h, ncore, debug)
}

#' @rdname rplba1R
#' @export
n1PDF_plba3 <- function(x, n, A, B, C, mean_v, sd_v, mean_w, sd_w, rD, tD, swt, t0, h) {
    .Call('_ggdmc_n1PDF_plba3', PACKAGE = 'ggdmc', x, n, A, B, C, mean_v, sd_v, mean_w, sd_w, rD, tD, swt, t0, h)
}

dprior_ <- function(pvec, dists, p1, p2, lower, upper, islog) {
    .Call('_ggdmc_dprior_', PACKAGE = 'ggdmc', pvec, dists, p1, p2, lower, upper, islog)
}

sumlogprior <- function(pvec, dists, p1, p2, lower, upper, islog) {
    .Call('_ggdmc_sumlogprior', PACKAGE = 'ggdmc', pvec, dists, p1, p2, lower, upper, islog)
}

#' Probability densities of prior distributions
#'
#' \code{sumlogpriorNV} calculate sum log-likelihood. \code{rprior} generates
#' random observation from prior distributions
#'
#' @param pvec parameter vector
#' @param prior prior distributions
#'
#' @return a vector
#' @export
dprior <- function(pvec, prior) {
    .Call('_ggdmc_dprior', PACKAGE = 'ggdmc', pvec, prior)
}

#' @rdname rprior
#' @export
rprior_scalar <- function(prior) {
    .Call('_ggdmc_rprior_scalar', PACKAGE = 'ggdmc', prior)
}

#' @rdname rprior
#' @export
rprior_mat <- function(prior, n) {
    .Call('_ggdmc_rprior_mat', PACKAGE = 'ggdmc', prior, n)
}

rprior_vec <- function(dists, p1, p2, lower, upper) {
    .Call('_ggdmc_rprior_vec', PACKAGE = 'ggdmc', dists, p1, p2, lower, upper)
}

rprior <- function(n, dists, p1, p2, lower, upper) {
    .Call('_ggdmc_rprior', PACKAGE = 'ggdmc', n, dists, p1, p2, lower, upper)
}

#' @rdname dprior
#' @export
sumlogpriorNV <- function(pvec, prior) {
    .Call('_ggdmc_sumlogpriorNV', PACKAGE = 'ggdmc', pvec, prior)
}

#' Generate a Gamma Vector
#'
#' This is part of DE-MCMC algorithm. This function generates a gamma vector
#' for element-wise computation in Armadillo C++. This function is based on
#' p242 ter Braak (2006) who cited Roberts and Rosenthal (2001)
#'
#' @param npar number of parameters.
#' @param gammamult a tuning parameter stands for for gamma mutation. Default
#' value is 2.38.
#' @param hyper a boolean switch, indicating to calculate hyper gamma
#' @return a vector
#' @examples
#' pVec <- c(A = 1.51, b = 2.7, muv1 = 3.32, muv2 = 2.24, t_ND = 0.08,
#'           muw1 = 1.51, muw2 = 3.69, t_delay = 0.31, sv = 1, swt = 0.5)
#' gamma <- GetGamma(length(pVec), 2.38)
#' @export
GetGamma <- function(npar, gammamult, hyper = FALSE) {
    .Call('_ggdmc_GetGamma', PACKAGE = 'ggdmc', npar, gammamult, hyper)
}

#' Draw n other chains and shuffle them
#'
#' This is part of DE-MCMC algorithm. \code{PickChains} draws \code{n}
#' chains out of \code{length(chains)} chains, excluding the kth chain.
#' \code{GetSubchains} is used in \code{migration} operator. It draws a subset
#' of chains in \code{nchain} chains.
#'
#' \code{Getsubchains} is part of the Migration algroithms. It does two-step
#' shuffling. In step 1, it selects a number l (integer) uniformly between 1
#' and k to be the number of subpopulations for migration.  In step 2, it
#' generates the chain index (0 to nchain - 1) and lastely it shuffles them
#'
#'
#' @param k the kth processed chain. Must be an integer within the range of 0
#' to \code{nchain - 1}. No check for errorly using R index.
#' @param nchain number of chains to draw.
#' @param chains an integer vector, indicating chain index, e.g., 0:23
#' @param ngroup number of distributed groups
#' @return a column vector
#' @keywords PickChains, getsubchains
#' @export
#' @examples
#' chains <- 0:23
#'
#' ## Presuming current processing chain is the 1st chain (C index = 0)
#' ## pick 2 chains out of 24 chains, excluding current chain.
#' PickChains(0, 2, chains)
#'
#' ## Example outputs
#' ##      [,1]
#' ## [1,]   17
#' ## [2,]   12
#' ##      [,1]
#' ## [1,]    2
#' ## [2,]    5
#' ##      [,1]
#' ## [1,]    5
#' ## [2,]    3
#' ##      [,1]
#' ## [1,]   10
#' ## [2,]    8
#' ##      [,1]
#' ## [1,]   15
#' ## [2,]    8
#'
#' ## get a random number of subchains
#' GetSubchains(24)
#' ##       [,1]
#' ##  [1,]    0
#' ##  [2,]    3
#' ##  [3,]    5
#' ##  [4,]    9
#' ##  [5,]   10
#' ##  [6,]   12
#' ##  [7,]   14
#' ##  [8,]   15
#' ##  [9,]   18
#' ## [10,]   20
#' ## [11,]   21
#' ## [12,]   22
#'
#' @export
PickChains <- function(k, nchain, chains) {
    .Call('_ggdmc_PickChains', PACKAGE = 'ggdmc', k, nchain, chains)
}

#' @rdname PickChains
#' @export
GetSubchains <- function(nchain) {
    .Call('_ggdmc_GetSubchains', PACKAGE = 'ggdmc', nchain)
}

#' @rdname PickChains
#' @export
SelectEmigrants <- function(ngroup, k) {
    .Call('_ggdmc_SelectEmigrants', PACKAGE = 'ggdmc', ngroup, k)
}

run_dgmc <- function(samples, force, report, pm, qm, gammamult, ncore, ngroup) {
    .Call('_ggdmc_run_dgmc', PACKAGE = 'ggdmc', samples, force, report, pm, qm, gammamult, ncore, ngroup)
}

run_dmc <- function(samples, force, report, pm, gammamult, ncore, slice) {
    .Call('_ggdmc_run_dmc', PACKAGE = 'ggdmc', samples, force, report, pm, gammamult, ncore, slice)
}

run_hyper_dmc <- function(samples, report, pm, hpm, gammamult, ncore, debug) {
    .Call('_ggdmc_run_hyper_dmc', PACKAGE = 'ggdmc', samples, report, pm, hpm, gammamult, ncore, debug)
}

run_hyper_dgmc <- function(samples, report, pm, hpm, qm, hqm, gammamult, ngroup, ncore) {
    .Call('_ggdmc_run_hyper_dgmc', PACKAGE = 'ggdmc', samples, report, pm, hpm, qm, hqm, gammamult, ngroup, ncore)
}

rtn_scalar <- function(mean, sd, l, u) {
    .Call('_ggdmc_rtn_scalar', PACKAGE = 'ggdmc', mean, sd, l, u)
}

#' Truncated Normal Distribution
#'
#' Random number generation, probability density and cumulative density
#' functions for truncated normal distribution.
#'
#' @param x,q vector of quantiles;
#' @param n number of observations. n must be a scalar.
#' @param mean mean (must be scalar).
#' @param sd standard deviation (must be scalar).
#' @param lower lower truncation value (must be scalar).
#' @param upper upper truncation value (must be scalar).
#' @param lt lower tail. If TRUE (default) probabilities are \code{P[X <= x]},
#' otherwise, \code{P[X > x]}.
#' @param log log probability. If TRUE (default is FALSE) probabilities p are
#' given as \code{log(p)}.
#' @return a column vector.
#' @examples
#' ## rtn example
#' dat1 <- rtnorm(1e5, 0, 1, 0, Inf)
#' hist(dat1, breaks = "fd", freq = FALSE, xlab = "",
#'      main = "Truncated normal distributions")
#'
#' ## dtn example
#' x <- seq(-5, 5, length.out = 1e3)
#' dat1 <- dtnorm(x, 0, 1, -2, 2, 0)
#' plot(x, dat1, type = "l", lwd = 2, xlab = "", ylab= "Density",
#'      main = "Truncated normal distributions")
#'
#' ## ptn example
#' x <- seq(-50, 10, length.out = 1e3)
#' mean <- 0
#' sd <- 1
#' lower <- 0
#' upper <- 5
#' dat1 <- ptnorm(x, 0, 1, 0, 5, log = TRUE)
#' @export
dtnorm <- function(x, mean, sd, lower, upper, log = FALSE) {
    .Call('_ggdmc_dtnorm', PACKAGE = 'ggdmc', x, mean, sd, lower, upper, log)
}

#' @rdname dtnorm
#' @export
rtnorm <- function(n, mean, sd, lower, upper) {
    .Call('_ggdmc_rtnorm', PACKAGE = 'ggdmc', n, mean, sd, lower, upper)
}

#' @rdname dtnorm
#' @export
ptnorm <- function(q, mean, sd, lower, upper, lt = TRUE, log = FALSE) {
    .Call('_ggdmc_ptnorm', PACKAGE = 'ggdmc', q, mean, sd, lower, upper, lt, log)
}

#' Whether a hyper-prior distribution is set constant
#'
#' Check if a prior distribution for a location and scale parameter is set
#' constant. \code{testHyper} checks if the parameter names in location and
#' in scale match.
#'
#' @param ppprior hyper-parameter prior distributions. First element is a
#' location prior and second is a scale prior.
#' @return \code{isConstant} gives a npar x 2 matrix;
#' @examples
#' model <- BuildModel(p.map = list(A = "1", B = "R", t0 = "1",
#'   mean_v = c("F", "M"), sd_v = "M", st0 = "1"),
#'   match.map = list(M = list(s1=1, s2=2)),
#'   factors   = list(S = c("s1", "s2"),F = c("f1", "f2")),
#'     constants = c(sd_v.false = 1, st0 = 0),
#'     responses = c("r1", "r2"),
#'     type      = "norm")
#'   npar <- length(GetPNames(model))
#'
#' ## Population distribution, rate effect on F
#'   pop.mean <- c(A=.4, B.r1=.6, B.r2=.8, t0=.3, mean_v.f1.true=1.5,
#'     mean_v.f2.true=1, mean_v.f1.false=0, mean_v.f2.false=0,
#'     sd_v.true = .25)
#'     pop.scale <-c(A=.1, B.r1=.1, B.r2=.1, t0=.05, mean_v.f1.true=.2,
#'       mean_v.f2.true=.2, mean_v.f1.false=.2, mean_v.f2.false=.2,
#'       sd_v.true = .1)
#'     p.prior <- BuildPrior(
#'         dists = rep("tnorm", npar),
#'         p1    = pop.mean,
#'         p2    = pop.scale*5,
#'         lower = c(0,0,0,.1,NA,NA,NA,NA,0),
#'         upper = c(NA,NA,NA,NA,NA,NA,NA,NA,NA))
#'     mu.prior <- BuildPrior(
#'         dists = rep("tnorm", npar),
#'         p1    = pop.mean,
#'         p2    = c(1,1,1,1,2,2,2,2,1),
#'         lower = c(0,0,0,.1,NA,NA,NA,NA,0),
#'         upper = c(NA,NA,NA,NA,NA,NA,NA,NA,NA))
#'     sigma.prior <- BuildPrior(
#'         dists = rep("beta", npar),
#'         p1    = c(A=1, B.r1=1, B.r2=1, t0=1, mean_v.f1.true=1,
#'           mean_v.f2.true=1, mean_v.f1.false=1, mean_v.f2.false=1,
#'           sd_v.true = 1),
#'           p2    = rep(1, npar))
#'     pp.prior <- list(mu.prior, sigma.prior)
#'
#'     test1 <- GetConstIdx(pp.prior)
#'     test2 <- lapply(pp.prior,function(x){
#'       lapply(x,function(y){attr(y,"dist") == "constant"})})
#' @export
GetConstIdx <- function(ppprior) {
    .Call('_ggdmc_GetConstIdx', PACKAGE = 'ggdmc', ppprior)
}

MatchPnames <- function(samples) {
    .Call('_ggdmc_MatchPnames', PACKAGE = 'ggdmc', samples)
}

MatchPPPriorName <- function(ppprior) {
    .Call('_ggdmc_MatchPPPriorName', PACKAGE = 'ggdmc', ppprior)
}

CheckPnames <- function(samples) {
    invisible(.Call('_ggdmc_CheckPnames', PACKAGE = 'ggdmc', samples))
}

CheckHyperPnames <- function(samples) {
    invisible(.Call('_ggdmc_CheckHyperPnames', PACKAGE = 'ggdmc', samples))
}

#' Convert cell index list to a matrix
#'
#' Convert cell index list to a matrix. This is a convenient function.
#'
#' @param data a model data instance
#' @return a matrix
#'
#' @examples
#' m1 <- BuildModel(
#'     p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
#'     match.map = list(M=list(s1="r1", s2="r2")),
#'     factors   = list(S=c("s1", "s2")),
#'     constants = c(st0=0, d=0),
#'     responses = c("r1","r2"),
#'     type      = "rd")
#' p.prior <- BuildPrior(
#'     dists = rep("tnorm", 6),
#'     p1    = c(a=2,  v=2.5, z=.5, sz=.3, sv=1,  t0=.3),
#'     p2    = c(a=.5, v=.5,  z=.1, sz=.1, sv=.3, t0=.05),
#'     lower = c(0,-5, 0, 0, 0, 0),
#'     upper = c(5, 7, 2, 2, 2, 2))
#' dat <- simulate(m1, nsim = 4, prior = p.prior)
#' dmi <- BuildDMI(dat, m1)
#' cellIdx2Mat(dmi)
#' @export
cellIdx2Mat <- function(data) {
    .Call('_ggdmc_cellIdx2Mat', PACKAGE = 'ggdmc', data)
}

ac_ <- function(x, nlag) {
    .Call('_ggdmc_ac_', PACKAGE = 'ggdmc', x, nlag)
}

