% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{GetParameterMatrix}
\alias{GetParameterMatrix}
\title{Return ns-npar matrix}
\usage{
GetParameterMatrix(x, ns, prior = NA, ps = NA, seed = NULL)
}
\arguments{
\item{x}{a model object}

\item{ns}{number of subjects.}

\item{prior}{a list of parameter prior distributions}

\item{ps}{a vector or matirx. Each row indicates a set of true parameters
for a participant.}

\item{seed}{an integer specifying if and how the random number generator
should be initialized.}
}
\description{
Contructs a ns x npar matrix, indicating the true paramters
used to simualte data. Each row represents a set of parameters for a
participant. One should enter either a valid vector or matrix for
true parameters (i.e., ps) or a list of (parameter) prior distributions
(p.prior). When \code{p.prior} is supplied, true parameters are drawn
from prior distributions.
}
\examples{
model <- BuildModel(
p.map     = list(a ="1", v = "1",z = "1", d = "1", sz = "1", sv = "1",
            t0 = "1", st0 = "1"),
match.map = list(M = list(s1 = "r1", s2 ="r2")),
factors   = list(S = c("s1", "s2")),
constants = c(st0 = 0, d = 0),
responses = c("r1", "r2"),
type      = "rd")

p.prior <- BuildPrior(
  dists = c("tnorm", "tnorm", "beta", "beta", "tnorm", "beta"),
  p1    = c(a = 1, v = 0, z = 1, sz = 1, sv = 1, t0 = 1),
  p2    = c(a = 1, v = 2, z = 1, sz = 1, sv = 1, t0 = 1),
  lower = c(0, -5, NA, NA, 0, NA),
  upper = c(2,  5, NA, NA, 2, NA))

## Example 1: Randomly generate 2 sets of true parameters from
## parameter priors (p.prior)
GetParameterMatrix(model, 2, p.prior)
##            a         v         z        sz       sv        t0
## [1,] 1.963067  1.472940 0.9509158 0.5145047 1.344705 0.0850591
## [2,] 1.512276 -1.995631 0.6981290 0.2626882 1.867853 0.1552828

## Example 2: Use a user-selected true parameters
true.vector  <- c(a=1, v=1, z=0.5, sz=0.2, sv=1, t0=.15)
GetParameterMatrix(model, 2, NA, true.vector)
##      a v   z  sz sv   t0
## [1,] 1 1 0.5 0.2  1 0.15
## [2,] 1 1 0.5 0.2  1 0.15
GetParameterMatrix(model, 2, ps = true.vector)

## Example 3: When a user enter arbritary sequence of parameters.
## Note sv is before sz. It should be sz before sv
## See correct sequence, by entering "attr(model, 'p.vector')"
## GetParameterMatrix will rearrange the sequence.
true.vector  <- c(a=1, v=1, z=0.5, sv=1, sz = .2, t0=.15)
GetParameterMatrix(model, 2, NA, true.vector)
##      a v   z  sz sv   t0
## [1,] 1 1 0.5 0.2  1 0.15
## [2,] 1 1 0.5 0.2  1 0.15

}
