% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/random.R
\name{rplba0}
\alias{rplba0}
\alias{rplba1}
\alias{rplba2}
\alias{rplba3}
\alias{n1PDF_plba1}
\alias{n1PDF_plba2}
\alias{n1PDF_plba3}
\alias{rplba1R}
\alias{rplba2R}
\alias{rplba3R}
\title{Piecewise LBA model}
\usage{
rplba0(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore = 1L,
  debug = FALSE)

rplba1(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore = 1L,
  debug = FALSE)

rplba2(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt, ncore = 1L,
  debug = FALSE)

rplba3(n, A, B, C, mean_v, mean_w, sd_v, sd_w, rD, tD, swt, t0)

n1PDF_plba1(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, h, ncore, debug)

n1PDF_plba2(x, A, b, mean_v, sd_v, t0, mean_w, sd_w, rD, swt, n, h, ncore,
  debug)

n1PDF_plba3(x, n, A, B, C, mean_v, sd_v, mean_w, sd_w, rD, tD, swt, t0, h)

rplba1R(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt)

rplba2R(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt)

rplba3R(n = 10, pVec = c(A1 = 1.5, A2 = 1.5, B1 = 1.2, B2 = 1.2, C1 =
  0.3, C2 = 0.3, v1 = 3.32, v2 = 2.24, w1 = 1.51, w2 = 3.69, sv1 = 1, sv2 =
  1, sw1 = 1, sw2 = 1, rD = 0.3, tD = 0.3, swt = 0.5, t0 = 0.08))
}
\arguments{
\item{n}{number of observations.}

\item{A}{upper bound of start point. It can be an integer or a 2-element
vector.}

\item{b}{response threshold. It can be an integer or a 2-element vector.}

\item{t0}{nondecision time (in second)}

\item{mean_v}{stage 1 mean drift rate. It must be a 2-element vector}

\item{mean_w}{stage 2 mean drift rate. It must be a 2-element vector}

\item{sd_v}{common standard deviation of the piece 1 drift rates. If
sd_w is not present, this will also be used as the piece 2 drift rate
standard deviation, which cannot be negative.}

\item{rD}{drift rate delay (in second)}

\item{swt}{switch time (in second)}

\item{ncore}{number of CPU cores for running Open MP.}

\item{debug}{internal debug switch}

\item{sd_w}{standard deviation of the piece 2 drift rates}

\item{B}{first stage traveling distance}

\item{C}{second stage traveling distance}

\item{tD}{threshold delay time}

\item{x}{vector of quantiles.}

\item{h}{bandwidth for the kernel function}

\item{pVec}{PLBA parameter vector}
}
\value{
a [RT R] matrix (C++) or a data frame (R)
}
\description{
Density and random generation of the PLBA Model Type 0, 1, and 2.
}
\examples{
#########################################################################80
## rplba1
#########################################################################80
\dontrun{
n <- 2^20; n
A <- 1.5
b <- 2.7
mean_v <- c(3.3, 2.2)
mean_w <- c(1.5, 3.7)
sd_v <- c(1, 1)
rD    <- .3
swt   <- .5
t0    <- .08
ncore <- 12
dat1 <- rplba1R(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt)
dat2 <- rplba1(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt, ncore)
dat3 <- ppda::rplba1(n, A, b, t0, mean_v, mean_w, sd_v, rD, swt)

dat1r1 <- dat1[dat1[, 2] == 1, 1]
dat1r2 <- dat1[dat1[, 2] == 2, 1]
dat2r1 <- dat2[dat2[, 2] == 1, 1]
dat2r2 <- dat2[dat2[, 2] == 2, 1]
dat3r1 <- dat3[dat3[, 2] == 1, 1]
dat3r2 <- dat3[dat3[, 2] == 2, 1]

xlim <- c(0, 3)
## Check if two methods produce SPDF overlaping with each other
par(mfrow = c(4, 2), mar = c(4, 5.3, 0.82, 1))
hist(dat1r1, breaks = "fd", freq = FALSE, main = "Choice1 R", xlim = xlim)
hist(dat1r2, breaks = "fd", freq = FALSE, main = "Choice2 R", xlim = xlim)
hist(dat2r1, breaks = "fd", freq = FALSE, main = "Choice1 C++", xlim = xlim)
hist(dat2r2, breaks = "fd", freq = FALSE, main = "Choice2 C++", xlim = xlim)
hist(dat3r1, breaks = "fd", freq = FALSE, main = "Choice1 GPU", xlim = xlim)
hist(dat3r2, breaks = "fd", freq = FALSE, main = "Choice2 GPU", xlim = xlim)

par(mfrow = c(1, 2))
hist(dat1r1, breaks = "fd", freq = FALSE, main = "Choice1 R, C++, & GPU",
  xlim = xlim, ylim = c(0, 3))
hist(dat2r1, breaks = "fd", freq = FALSE, add = TRUE, col = "lightblue")
hist(dat3r1, breaks = "fd", freq = FALSE, add = TRUE, col = "lightgreen")

hist(dat1r2, breaks = "fd", freq = FALSE, main = "Choice2 R, C++ & GPU",
  xlim = xlim, ylim = c(0, 3))
hist(dat2r2, breaks = "fd", freq = FALSE, add = TRUE, col = "lightblue")
hist(dat3r2, breaks = "fd", freq = FALSE, add = TRUE, col = "lightgreen")
}

#############20
## rplba2    ##
#############20
\dontrun{
n <- 2^15
ncore <- 4
A <- c(1.5, 1.5)
b <- c(2.7, 2.7)
mean_v <- c(3.3, 2.2)
mean_w <- c(1.5, 3.7)
sd_v <- c(1, 1)
sd_w <- c(1, 1)
rD <- .3
swt <- .5
t0 <- .08
dat1 <- rplba2R(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt)
dat2 <- rplba2(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt, ncore)
dat3 <- rplba2(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt)
dat4 <- rplba2_test(n, A, b, t0, mean_v, mean_w, sd_v, sd_w, rD, swt)

dat1r1 <- dat1[dat1[, 2] == 1, 1]
dat1r2 <- dat1[dat1[, 2] == 2, 1]
dat2r1 <- dat2[dat2[, 2] == 1, 1]
dat2r2 <- dat2[dat2[, 2] == 2, 1]
dat3r1 <- dat3[dat3[, 2] == 1, 1]
dat3r2 <- dat3[dat3[, 2] == 2, 1]
dat4r1 <- dat4[dat4[, 2] == 1, 1]
dat4r2 <- dat4[dat4[, 2] == 2, 1]

wesanderson::wes_palette("Royal1")
palettes  <- wesanderson::wes_palettes$GrandBudapest
palettes2 <- wesanderson::wes_palettes$GrandBudapest2
xlim <- c(0, 3)
## Check if two methods produce SPDF overlaping with each other
par(mfrow = c(4, 2), mar = c(4, 5.3, 0.82, 1))
hist(dat1r1, breaks = "fd", freq = FALSE, main = "Choice1 R", xlim = xlim)
hist(dat1r2, breaks = "fd", freq = FALSE, main = "Choice2 R", xlim = xlim)
hist(dat2r1, breaks = "fd", freq = FALSE, main = "Choice1 C++", xlim = xlim)
hist(dat2r2, breaks = "fd", freq = FALSE, main = "Choice2 C++", xlim = xlim)
hist(dat3r1, breaks = "fd", freq = FALSE, main = "Choice1 GPU", xlim = xlim)
hist(dat3r2, breaks = "fd", freq = FALSE, main = "Choice2 GPU", xlim = xlim)
hist(dat4r1, breaks = "fd", freq = FALSE, main = "Choice1 test", xlim = xlim)
hist(dat4r2, breaks = "fd", freq = FALSE, main = "Choice2 test", xlim = xlim)

par(mfrow = c(1, 2))
hist(dat1r1, breaks = "fd", freq = FALSE, main = "Choice1 R, C++, & GPU",
  xlim = xlim, ylim = c(0, 3))
hist(dat2r1, breaks = "fd", freq = FALSE, add = TRUE, col = palettes[1])
hist(dat3r1, breaks = "fd", freq = FALSE, add = TRUE, col = palettes[2])
hist(dat4r1, breaks = "fd", freq = FALSE, add = TRUE, col = palettes[4])

hist(dat1r2, breaks = "fd", freq = FALSE, main = "Choice2 R, C++ & GPU",
  xlim = xlim, ylim = c(0, 3))
hist(dat2r2, breaks = "fd", freq = FALSE, add = TRUE, col = palettes2[1])
hist(dat3r2, breaks = "fd", freq = FALSE, add = TRUE, col = palettes2[2])
hist(dat4r2, breaks = "fd", freq = FALSE, add = TRUE, col = palettes2[3])


}
}
\references{
Holmes, R. W., Trueblood, J. & Heathcote, A. (2016). A new
framework for modeling decisions about changing information: The Piecewise
Linear Ballistic Accumulator model. \emph{Cognitive Psychology}, 85, 1--29,
doi: http://dx.doi.org/10.1016/j.cogpsych.2015.11.002.Approximate
}
