% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{print.prior}
\alias{print.prior}
\title{Print Prior Distribution}
\usage{
\method{print}{prior}(x, ...)
}
\arguments{
\item{x}{a list of prior distributions list, usually created by
\code{BuildPrior}}

\item{...}{other arguments}
}
\value{
a data frame listing prior distributions and their settings
}
\description{
a convenient function to rearrange \code{p.prior} or an element in a
\code{pp.prior} as a data frame for inspection.
}
\examples{
pop.mean  <- c(a=1,  v.f1=1,  v.f2=.2, z=.5, sz=.3,  sv.f1=.25, sv.f2=.23,
               t0=.3)
pop.scale <- c(a=.2, v.f1=.2, v.f2=.2, z=.1, sz=.05, sv.f1=.05, sv.f2=.05,
               t0=.05)

p.prior <- BuildPrior(
  dists = rep("tnorm", 8),
  p1    = pop.mean,
  p2    = pop.scale,
  lower = c(0, -5, -5, 0, 0, 0, 0, 0),
  upper = c(2,  5,  5, 1, 2, 2, 1, 1))

print(p.prior)
}
