% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gge.R
\name{nipals}
\alias{nipals}
\title{PCA by non-linear iterative partial least squares in C++}
\usage{
nipals(x, maxcomp = min(nrow(x), ncol(x) - 1), maxiter = 5000,
  tol = 1e-06, propvar = 1, center = TRUE, scale. = FALSE, ...)
}
\arguments{
\item{x}{Numerical matrix}

\item{maxcomp}{Maximum number of principal components to extract.}

\item{maxiter}{Maximum number of NIPALS iterations to perform.}

\item{tol}{Default 1e-6 tolerance for testing convergence of the algorithm.}

\item{propvar}{The proportion of variance that should be explained by the
returned principal components. If propvar < 1, then \code{maxcomp} is ignored.}

\item{center}{If TRUE, do center columns.}

\item{scale.}{If FALSE, do not scale columns.}

\item{...}{Only used for passing through arguments.}
}
\value{
A list with components.
}
\description{
Used for finding principal components of a numeric matrix.  Components
are extracted one a time.  Missing values in the matrix are allowed.
}
\references{
Wold, H. (1966) Estimation of principal components and
related models by iterative least squares. In Multivariate
Analysis (Ed., P.R. Krishnaiah), Academic Press, NY, 391-420.
}
\author{
Henning Redestig
}
