% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotPath}
\alias{plotPath}
\title{Construct the graphic object of the path}
\usage{
plotPath(path, fontFace = 1)
}
\arguments{
\item{path}{object created from function getPath}

\item{fontFace}{fontface for the two nodes of interest (1=plain, 2=bold, 3=italic, 4=bold-italic), DEFAULT is 1}
}
\description{
This function takes the path as input and outputs an ggplot2 object. The
image will correctly position the node labels with x-axis representing the node
year, and y-axis representing the node path index. Edges between two nodes represent
parent-child relationships between those nodes. For visual appeal, there is a grey
box that outlines the node label, as well as an underline and overline for each label.
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
p <- getPath("Brim", "Bedford", ig, sbGeneal)
plotPath(p)
plotPath(p, fontFace = 4)
}
\seealso{
\code{\link{getPath}} for information on input path building
}

