% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{mca_interpret}
\alias{mca_interpret}
\title{Helper table to interpret multiple correspondence analysis}
\usage{
mca_interpret(
  res.mca = res.mca,
  axes = 1:min(res.mca$call$ncp, 5),
  type = c("html", "console")
)
}
\arguments{
\item{res.mca}{An object created with \code{FactoMineR::\link[FactoMineR]{MCA}},}

\item{axes}{The axes to interpret, as an integer vector. Default to the first five axes.}

\item{type}{By default, a html table is printed. Set to \code{"console"} to print in
console or axes the numbers as a data.frame.}
}
\value{
An html table (or a \code{tibble}).
}
\description{
A table to help to interpret the meaning of axes in multiple
correspondence analysis (MCA), based on Brigitte Le Roux, \emph{Analyse geometrique des
donnees multidimensionnelles}, Dunod, Paris, 2014 / Brigitte Le Roux and Henri Rouanet,
\emph{Geometric data analysis : from correspondence analysis to structured data
analysis}, Kluwer, Boston, 2004. Only levels whose relative contribution to the
variance of axis is superior to the mean contribution are kept. The spread between
positive levels and negative levels of the same variable is calculated in percentages
of the variance of the question/variable.
}
\examples{
\donttest{
data(tea, package = "FactoMineR")
res.mca <- MCA2(tea, active_vars = 1:18)
mca_interpret(res.mca)
}
}
