% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{pca_interpret}
\alias{pca_interpret}
\title{Colored Table to Help Interpretation of Principal Component Analysis}
\usage{
pca_interpret(res.pca, axes = 1:3)
}
\arguments{
\item{res.pca}{The result of \code{\link[FactoMineR:PCA]{FactoMineR::PCA}}.}

\item{axes}{The axes to print, as a numeric vector.}
}
\value{
A tibble of class tabxplor
}
\description{
Colored Table to Help Interpretation of Principal Component Analysis
}
\examples{

data(mtcars, package = "datasets")
mtcars <- mtcars[1:7] |> dplyr::rename(weight = wt)
res.pca <- FactoMineR::PCA(mtcars, graph = FALSE)
pca_interpret(res.pca)

}
