% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{geom_link}
\alias{geom_link}
\alias{stat_link}
\alias{stat_link2}
\alias{geom_link2}
\alias{geom_link0}
\title{Link points with paths}
\usage{
stat_link(
  mapping = NULL,
  data = NULL,
  geom = "path",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  n = 100,
  inherit.aes = TRUE,
  ...
)

stat_link2(
  mapping = NULL,
  data = NULL,
  geom = "path_interpolate",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  n = 100,
  inherit.aes = TRUE,
  ...
)

geom_link(
  mapping = NULL,
  data = NULL,
  stat = "link",
  position = "identity",
  arrow = NULL,
  lineend = "butt",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  n = 100,
  ...
)

geom_link2(
  mapping = NULL,
  data = NULL,
  stat = "link2",
  position = "identity",
  arrow = NULL,
  lineend = "butt",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  n = 100,
  ...
)

geom_link0(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  arrow = NULL,
  arrow.fill = NULL,
  lineend = "butt",
  linejoin = "round",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{n}{The number of points to create for each segment}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{lineend}{Line end style (round, butt, square).}

\item{arrow.fill}{fill colour to use for the arrow head (if closed). \code{NULL}
means use \code{colour} aesthetic.}

\item{linejoin}{Line join style (round, mitre, bevel).}
}
\description{
This set of geoms makes it possible to connect points using straight lines.
Before you think \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} and
\code{\link[ggplot2:geom_path]{ggplot2::geom_path()}}, these functions have some additional tricks
up their sleeves. geom_link connects two points in the same way as
\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} but does so by interpolating multiple
points between the two. An additional column called index is added to the
data with a sequential progression of the interpolated points. This can be
used to map color or size to the direction of the link. geom_link2 uses the
same syntax as \code{\link[ggplot2:geom_path]{ggplot2::geom_path()}} but interpolates between the
aesthetics given by each row in the data.
}
\section{Aesthetics}{

geom_link understand the following aesthetics (required aesthetics are in
bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{xend}
\item \strong{yend}
\item color
\item size
\item linetype
\item alpha
\item lineend
}

geom_link2 understand the following aesthetics (required aesthetics are in
bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item color
\item size
\item linetype
\item alpha
\item lineend
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The interpolated point coordinates}
\item{index}{The progression along the interpolation mapped between 0 and 1}
}
}

\examples{
# Lets make some data
lines <- data.frame(
  x = c(5, 12, 15, 9, 6),
  y = c(17, 20, 4, 15, 5),
  xend = c(19, 17, 2, 9, 5),
  yend = c(10, 18, 7, 12, 1),
  width = c(1, 10, 6, 2, 3),
  colour = letters[1:5]
)

ggplot(lines) +
  geom_link(aes(x = x, y = y, xend = xend, yend = yend, colour = colour,
                alpha = stat(index), size = stat(index)))

ggplot(lines) +
  geom_link2(aes(x = x, y = y, colour = colour, size = width, group = 1),
             lineend = 'round', n = 500)

# geom_link0 is simply an alias for geom_segment to put the link geoms in
# line with the other line geoms with multiple versions. `index` is not
# available here
ggplot(lines) +
  geom_link0(aes(x = x, y = y, xend = xend, yend = yend, colour = colour))
}
