% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggformula-package.R
\docType{package}
\name{ggformula}
\alias{ggformula}
\alias{ggformula-package}
\title{ggformula: Formula Interface to the Grammar of Graphics}
\description{
Provides a formula interface to 'ggplot2' graphics.
}
\section{The ggformula system}{


The functions in \pkg{ggformula} provide a formula interface to \pkg{ggplot2} layer
functions and a system for working with pipes to create multi-layer
plots and to refine plots.
For plots with just one layer, the formula interface
is more compact than native \pkg{ggplot2} code and is consistent with modeling
functions like \code{\link[stats:lm]{stats::lm()}} that use a formula interface and with the
numerical summary functions in the \pkg{mosaic} package.
}

\section{Specifying plot attributes}{


Positional attributes (a.k.a aesthetics) are typically specified using a formula
(see the \code{gformula} argument).
Setting and mapping of additional attributes can be done through the use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.
A (sometimes partial) list of available attributes can be obtained by executing
plotting functions with no arguments.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to \code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{

Evaluation of the \pkg{ggplot2} code occurs in the environment specified
by \code{environment}. This will typically do the right thing, but is exposed
in case some non-standard behavior is desired. In earlier versions,
the environment of the formula was used, but since some functions in
the package do not require a formula, a separate argument is used now.
}

\examples{
apropos("gf_")
gf_point()
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ProjectMOSAIC/ggformula}
  \item Report bugs at \url{https://github.com/ProjectMOSAIC/ggformula/issues}
}

}
\author{
\strong{Maintainer}: Randall Pruim \email{rpruim@calvin.edu}

Authors:
\itemize{
  \item Daniel Kaplan \email{kaplan@macalester.edu}
}

}
\keyword{Formula}
\keyword{ggplot2}
\keyword{interface}
\keyword{internal}
\keyword{to}
