% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_aux.R
\name{gf_labs}
\alias{gf_labs}
\alias{gf_lims}
\alias{gf_facet_wrap}
\alias{gf_facet_grid}
\alias{gf_refine}
\title{Non-layer functions for gf plots}
\usage{
gf_labs(object, ...)

gf_lims(object, ...)

gf_facet_wrap(object, ...)

gf_facet_grid(object, ...)

gf_refine(object, ...)
}
\arguments{
\item{object}{a gg object}

\item{...}{additional arguments passed through to the similarly named function in
\pkg{ggplot2}.}
}
\value{
a modified gg object
}
\description{
These functions modify things like labels, limits, scales, etc. for plots
ggplot2 plots. They are wrappers around functions in ggplot2 that allow for
chaining syntax.
}
\details{
\code{gf_refine()} provides a mechanism to replace \code{+} with the
chaining operator from \pkg{magrittr}.
Each of its \code{\dots} arguments is added in turn to the
base plot in \code{object}.  The other functions are thin wrappers around
specific \code{ggplot2} refinement functions and pass their \code{\dots}
arguments through to the similarly named \code{ggplot2} functions.
}
