% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_linerange}
\alias{gf_linerange}
\title{Formula interface to geom_linerange()}
\usage{
gf_linerange(object = NULL, gformula = NULL, data = NULL,
  geom = "linerange", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{ymin + ymax ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{alpha}, \code{color}, \code{group}, \code{linetype}, \code{size}}
}
\value{
a gg object
}
\description{
\pkg{ggformula} functions provide a formula interface to \pkg{ggplot2} layer
functions.
For plots with just one layer, the formula interface
is more compact and is consistent with modeling and \pkg{mosaic} notation.
}
\details{
Positional aesthetics are typically specified using a formula (see the \code{gformula} argument).
Setting and mapping of additional attributes can be done through the use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
gf_linerange()
if (require(weatherData) & require(dplyr)) {
Temps <- NewYork2013 \%>\% mutate(city = "NYC") \%>\%
bind_rows(Mumbai2013 \%>\% mutate(city = "Mumbai")) \%>\%
bind_rows(London2013 \%>\% mutate(city = "London")) \%>\%
  mutate(date = lubridate::date(Time),
         month = lubridate::month(Time)) \%>\%
  group_by(city, date) \%>\%
  summarise(
    hi = max(Temperature, na.rm = TRUE),
    lo = min(Temperature, na.rm = TRUE),
    mid = (hi + lo)/2
  )

gf_ribbon(lo + hi ~ date, data = Temps, fill = ~city, alpha = 0.4) \%>\%
   gf_theme(theme = theme_minimal())
gf_linerange(lo + hi ~ date | city ~ ., color = ~mid, data = Temps) \%>\%
  gf_refine(scale_colour_gradientn(colors = rev(rainbow(5))))
gf_ribbon(lo + hi ~ date | city ~ ., data = Temps)
# Chaining in the data
Temps \%>\% gf_ribbon(lo + hi ~ date, alpha = 0.4) \%>\%
  gf_facet_grid(city ~ .)
}

}
\seealso{
\code{\link[=geom_linerange]{geom_linerange()}}
}
