% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{with_interpolate}
\alias{with_interpolate}
\title{Blend two layerrs together by averaging them out}
\usage{
with_interpolate(x, bg_layer, src_percent, bg_percent = 100 - src_percent, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{bg_layer}{The layer to blend with}

\item{src_percent, bg_percent}{The contribution of this layer and the
background layer to the result. Should be between 0 and 100}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
Two layers can be blended together in the literal sense (not like
\code{\link[=with_blend]{with_blend()}}) so that the result is the average of the two. This is the
purpose of \code{with_interpolate()}.
}
\examples{
library(ggplot2)
ggplot(mpg, aes(class, hwy)) +
  as_reference(geom_boxplot(), 'box') +
  with_interpolate(geom_point(), bg_layer = 'box', src_percent = 70)

}
\seealso{
Other blend filters: 
\code{\link{with_blend}()},
\code{\link{with_blend_custom}()},
\code{\link{with_mask}()}
}
\concept{blend filters}
