% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-depth.r
\name{stat_depth}
\alias{stat_depth}
\alias{stat_depth_filled}
\title{Depth estimates and contours}
\usage{
stat_depth(
  mapping = NULL,
  data = NULL,
  geom = "contour",
  position = "identity",
  contour = TRUE,
  contour_var = "depth",
  notion = "zonoid",
  notion_params = list(),
  n = 100L,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_depth_filled(
  mapping = NULL,
  data = NULL,
  geom = "contour_filled",
  position = "identity",
  contour = TRUE,
  contour_var = "depth",
  notion = "zonoid",
  notion_params = list(),
  n = 100L,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{contour}{If \code{TRUE}, contour the results of the depth estimation.}

\item{contour_var}{Character string identifying the variable to contour by.
Can be one of \code{"depth"} or \code{"ndepth"}. See the section on computed
variables for details.}

\item{notion}{Character; the name of the depth function (passed to
\code{\link[ddalpha:depth.]{ddalpha::depth.()}}).}

\item{notion_params}{List of additional parameters passed via \code{...} to
\code{\link[ddalpha:depth.]{ddalpha::depth.()}}.}

\item{n}{Number of grid points in each direction.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour}}
  \describe{
    \item{\code{bins}}{Number of contour bins. Overridden by \code{breaks}.}
    \item{\code{binwidth}}{The width of the contour bins. Overridden by \code{bins}.}
    \item{\code{breaks}}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}
  }}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Estimate data depth using \code{\link[ddalpha:depth.]{ddalpha::depth.()}}.
}
\details{
Depth is an extension of the univariate notion of rank to bivariate
(and sometimes multivariate) data (Rousseeuw &al, 1999). It comes in
several flavors and is the basis for \link[=stat_bagplot]{bagplots}.

\code{stat_depth()} is adapted from \code{\link[ggplot2:geom_density_2d]{ggplot2::stat_density_2d()}} and returns
depth values over a grid in the same format, so it is neatly paired with
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.
}
\section{Multidimensional position aesthetics}{

This statistical transformation is compatible with the convenience function
\code{\link[=aes_coord]{aes_coord()}}.

Some transformations (e.g. \code{\link[=stat_center]{stat_center()}}) commute with projection to the
lower (1 or 2)-dimensional biplot space. If they detect aesthetics of the
form \verb{..coord[0-9]+}, then \code{..coord1} and \code{..coord2} are converted to \code{x} and
\code{y} while any remaining are ignored.

Other transformations (e.g. \code{\link[=stat_spantree]{stat_spantree()}}) yield different results in a
lower-dimensional biplot when they are computed before versus after
projection. If the stat layer detects these aesthetics, then the
transformation is performed before projection, and the results in the first
two dimensions are returned as \code{x} and \code{y}.

A small number of transformations (\code{\link[=stat_rule]{stat_rule()}}) are incompatible with
these aesthetics but will accept \code{aes_coord()} without warning.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.

\code{stat_depth()} and \code{stat_depth_filled()} compute different variables
depending on whether contouring is turned on or off. With contouring off
(\code{contour = FALSE}), both stats behave the same, and the following
variables are provided:
\describe{
\item{\code{depth}}{the depth estimate}
\item{\code{ndepth}}{depth estimate, scaled to a maximum of 1}
}
With contouring on (\code{contour = TRUE}), either \code{\link[ggplot2:geom_contour]{ggplot2::stat_contour()}} or
\code{\link[ggplot2:geom_contour]{ggplot2::stat_contour_filled()}} is run after the depth estimate has been
obtained, and the computed variables are determined by these stats.
}

\examples{
# base Motor Trends plot
b <- ggplot(mtcars, aes(wt, disp)) + geom_point()

# depth raster
b + geom_raster(stat = "depth", aes(fill = after_stat(depth)))
# depth grid
b + stat_depth(
  geom = "point", contour = FALSE,
  aes(size = after_stat(depth)), n = 20
)

# depth contours
b + geom_contour(stat = "depth", contour = TRUE)
# depth bands
b + geom_contour_filled(stat = "depth_filled", contour = TRUE, alpha = .75)
# contours colored by group
b + stat_depth(aes(color = factor(cyl)))
# custom depth notion
b + stat_depth(
  aes(color = factor(cyl)),
  notion = "halfspace", notion_params = list(exact = TRUE)
)

# contours faceted by group
b + stat_depth_filled(alpha = .75) +
  facet_wrap(facets = vars(factor(cyl)))
# scaled to the unit interval
b + stat_depth_filled(contour_var = "ndepth", alpha = .75) +
  facet_wrap(facets = vars(factor(cyl)))
}
\references{
Rousseeuw PJ, Ruts I, & Tukey JW (1999) "The Bagplot: A Bivariate Boxplot".
\emph{The American Statistician}, \strong{53}(4): 382--387.
\doi{10.1080/00031305.1999.10474494}
}
\seealso{
Other stat layers: 
\code{\link{stat_bagplot}()},
\code{\link{stat_center}()},
\code{\link{stat_chull}()},
\code{\link{stat_cone}()},
\code{\link{stat_rule}()},
\code{\link{stat_scale}()},
\code{\link{stat_spantree}()}
}
\concept{stat layers}
