% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdx_geom_defaults.R
\name{hdx_geom_defaults}
\alias{hdx_geom_defaults}
\title{Default HDX geometries}
\usage{
hdx_geom_defaults()
}
\value{
A list of geometry defaults.
}
\description{
Default geometries fitting the HDX design guide. Used in \code{\link[=gghdx]{gghdx()}} to
set default fill, color, size, and point geometry defaults, which is not possible
using just \code{\link[=theme_hdx]{theme_hdx()}}.
}
\details{
Derived from the
\href{https://github.com/Mikata-Project/ggthemr/}{ggthemr} methods.
}
\examples{
library(purrr)

# updating geom defaults (like default color of a point or fill for bar)
purrr::walk(
  hdx_geom_defaults(),
  ~ do.call(what = ggplot2::update_geom_defaults, args = .),
)

}
\seealso{
\code{\link[=gghdx]{gghdx()}} for automically setting default geometries,
along with other styling.
}
