% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggheatmap.R
\name{ggheatmap}
\alias{ggheatmap}
\title{ggplot2 Version of Heatmap}
\usage{
ggheatmap(data,
  color=colorRampPalette(c( "#0073c2","white","#efc000"))(100),
  legendName="Express",
  scale="none",
  shape=NULL,
  border=NA,
  cluster_rows = F,
  cluster_cols = F,
  dist_method="euclidean",
  hclust_method="complete",
  text_show_rows=waiver(),
  text_show_cols=waiver(),
  text_position_rows="right",
  text_position_cols="bottom",
  annotation_cols=NULL,
  annotation_rows=NULL,
  annotation_color,
  annotation_width=0.03,
  annotation_position_rows="left",
  annotation_position_cols="top",
  show_cluster_cols=T,
  show_cluster_rows=T,
  cluster_num=NULL,
  tree_height_rows=0.1,
  tree_height_cols=0.1,
  tree_color_rows=NULL,
  tree_color_cols=NULL,
  tree_position_rows="left",
  tree_position_cols="top",
  levels_rows=NULL,
  levels_cols=NULL
)
}
\arguments{
\item{data}{input data(matrix or data.frame)}

\item{color}{the color of heatmap}

\item{legendName}{character,the title of heatmap legend}

\item{scale}{character,the way of scale data("none", "row" or "column")}

\item{border}{character, the colour of border}

\item{shape}{character, the shape of cell("square", "circle" and "triangle").Default is NULL}

\item{cluster_rows}{whether rows should be clustered(TRUE of FALSE)}

\item{cluster_cols}{whether column should be clustered(TRUE of FALSE)}

\item{dist_method}{character,the method parameter of dist function. see \link{dist}}

\item{hclust_method}{character,the method parameter of hclust function, see \link{hclust}}

\item{text_show_rows}{a character you want to show for y-axis}

\item{text_show_cols}{a character you want to show for x-axis}

\item{text_position_rows}{character,the position of y-axis label("right" or "left")}

\item{text_position_cols}{character,the position of x-axis label("bottom" or "top")}

\item{annotation_cols}{a data.frame for column annotation}

\item{annotation_rows}{a data.frame for row annotation}

\item{annotation_color}{a list for annotation color}

\item{annotation_width}{a numeric for annotation width}

\item{annotation_position_rows}{character,the position of column annotation("right" or "left")}

\item{annotation_position_cols}{character,the position of row annotation("bottom" or "top")}

\item{show_cluster_cols}{whether show column cluster tree(TRUE of FALSE)}

\item{show_cluster_rows}{whether show row cluster tree(TRUE of FALSE)}

\item{cluster_num}{a numeric for cut cluster tree}

\item{tree_height_rows}{row cluster tree height}

\item{tree_height_cols}{column cluster tree height}

\item{tree_color_rows}{a character for row cluster tree color}

\item{tree_color_cols}{a character for column cluster tree color}

\item{tree_position_rows}{character,the position of row cluster tree("right" or "left")}

\item{tree_position_cols}{character,the position of column cluster tree("bottom" or "top")}

\item{levels_rows}{a character for  y-axis label levels}

\item{levels_cols}{a character for  x-axis label levels}
}
\value{
p
}
\description{
The flexibility and excellence of 'ggplot2' is unquestionable,
so many drawing tools basically need 'ggplot2' as the operating object.
In order to develop a heatmap drawing system based on ggplot2, we developed
this tool, mainly to solve the heatmap puzzle problem and the flexible
connection between the heatmap and the 'ggplot2' object.
The advantages of this tool are as follows:
1. More flexible label settings;
2. Realize the linkage of heatmap and 'ggplot2' drawing system,
which is helpful for operations such as puzzles;
3. Simple and easy to operate;
4. Optimization of clustering tree visualization.
}
\author{
Baiwei Luo
}
