% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rect_interactive.R
\name{geom_rect_interactive}
\alias{geom_rect_interactive}
\title{add rectangles with tooltips or click actions or double click actions}
\usage{
geom_rect_interactive(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{position}{Postion adjustment, see \code{\link[ggplot2]{geom_point}}.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}
}
\description{
tooltips can be displayed when mouse is over rectangles, on click actions and
double click actions can be set with javascript instructions.
}
\examples{
# add interactive polygons to a ggplot -------
dataset = data.frame( x1 = c(1, 3, 1, 5, 4),
	x2 = c(2, 4, 3, 6, 6),
	y1 = c( 1, 1, 4, 1, 3),
	y2 = c( 2, 2, 5, 3, 5),
	t = c( 'a', 'a', 'a', 'b', 'b'),
	r = c( 1, 2, 3, 4, 5),
	tooltip = c("ID 1", "ID 2", "ID 3", "ID 4", "ID 5"),
	uid = c("ID 1", "ID 2", "ID 3", "ID 4", "ID 5"),
	oc = rep("function() {alert(this.getAttribute('data-id'))}", 5)
)

gg_rect = ggplot() +
	scale_x_continuous(name="x") +
	scale_y_continuous(name="y") +
	geom_rect_interactive(data=dataset,
		mapping = aes(xmin = x1, xmax = x2,
			ymin = y1, ymax = y2, fill = t,
			tooltip = tooltip, onclick = oc, data_id = uid ),
		color="black", alpha=0.5) +
	geom_text(data=dataset,
			aes(x = x1 + ( x2 - x1 ) / 2, y = y1 + ( y2 - y1 ) / 2,
					label = r ),
		size = 4 )


ggiraph(code = {print(gg_rect)})
}
\seealso{
\code{\link{ggiraph}}
}

