ggiraph R package
================

<p align="center">

<img width="15%" src="http://www.ardata.fr/images/ggiraphlogo.svg">

</p>

> Make ‘ggplot’ Graphics Interactive

[![Travis-CI Build
Status](https://travis-ci.org/davidgohel/ggiraph.svg?branch=master)](https://travis-ci.org/davidgohel/ggiraph)
[![Build
status](https://ci.appveyor.com/api/projects/status/github/davidgohel/ggiraph?branch=master)](https://ci.appveyor.com/project/davidgohel/ggiraph/branch/master)
[![version](http://www.r-pkg.org/badges/version/ggiraph)](https://CRAN.R-project.org/package=ggiraph)
![cranlogs](http://cranlogs.r-pkg.org./badges/ggiraph)
![Active](http://www.repostatus.org/badges/latest/active.svg)

## Overview

`ggiraph` is an htmlwidget and a ggplot2 extension. It allows ggplot
graphics to be animated.

Animation is made with ggplot geometries that can understand three
arguments:

  - `tooltip`: column of dataset that contains tooltips to be displayed
    when mouse is over elements.
  - `onclick`: column of dataset that contains javascript function to be
    executed when elements are clicked.
  - `data_id`: column of dataset that contains id to be associated with
    elements.

If used within a shiny application, elements associated with an id
(`data_id`) can be selected and manipulated on client and server
sides.

<!--html_preserve-->

<img src="data:image/gif;base64,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"/><!--/html_preserve-->

## Installation

##### Get development version on github

``` r
devtools::install_github('davidgohel/ggiraph')
```

##### Get CRAN version

``` r
install.packages("ggiraph")
```
