% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_dotplot_interactive.R
\name{geom_dotplot_interactive}
\alias{geom_dotplot_interactive}
\title{Create interactive dot plot}
\usage{
geom_dotplot_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}.}
}
\description{
This geometry is based on \code{\link[=geom_dotplot]{geom_dotplot()}}.
See the documentation for those functions for more details.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[=aes]{aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
library(ggplot2)
library(ggiraph)

gg_point = ggplot(
  data = mtcars,
  mapping = aes(
    x = factor(vs), fill = factor(cyl), y = mpg,
    tooltip = row.names(mtcars))) +
  geom_dotplot_interactive(binaxis = "y",
    stackdir = "center", position = "dodge")

x <- girafe(ggobj = gg_point)
if( interactive() ) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
