% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{ggiraph}
\alias{ggiraph}
\title{Create a ggiraph object}
\usage{
ggiraph(
  code,
  ggobj = NULL,
  pointsize = 12,
  width = 0.75,
  width_svg = 6,
  height_svg = 5,
  tooltip_extra_css = NULL,
  hover_css = NULL,
  tooltip_opacity = 0.9,
  tooltip_offx = 10,
  tooltip_offy = 0,
  tooltip_zindex = 999,
  zoom_max = 1,
  selection_type = "multiple",
  selected_css = NULL,
  dep_dir = NULL,
  ...
)
}
\arguments{
\item{code}{Plotting code to execute}

\item{ggobj}{ggplot object to print. Argument \code{code} will
be ignored if this argument is supplied.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width}{widget width ratio (0 < width <= 1).}

\item{width_svg, height_svg}{The width and height of the graphics region in inches.
The default values are 6 and 5 inches. This will define the aspect ratio of the
graphic as it will be used to define viewbox attribute of the SVG result.

If you use \code{girafe()} in an 'R Markdown' document, we
recommend not using these arguments so that the knitr
options \code{fig.width} and \code{fig.height} are used instead.}

\item{tooltip_extra_css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{hover_css}{css to apply when mouse is hover and element with a data-id attribute.}

\item{tooltip_opacity}{tooltip opacity}

\item{tooltip_offx}{tooltip x offset}

\item{tooltip_offy}{tooltip y offset}

\item{tooltip_zindex}{tooltip css z-index, default to 999.}

\item{zoom_max}{maximum zoom factor}

\item{selection_type}{row selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{selected_css}{css to apply when element is selected (shiny only).}

\item{dep_dir}{Deprecated; the path where the output files are stored. If \code{NULL},
the current path for temporary files is used.}

\item{...}{arguments passed on to \code{\link[=dsvg]{dsvg()}}}
}
\description{
Create an interactive graphic to be used in a web browser.

This function is maintained for backward compatibility reasons, user should
now use function \code{\link[=girafe]{girafe()}} and \code{\link[=girafe_options]{girafe_options()}}.
}
\examples{
# ggiraph simple example -------
library(ggplot2)
library(ggiraph)

dataset <- structure(list(qsec = c(16.46, 17.02, 18.61, 19.44, 17.02, 20.22
), disp = c(160, 160, 108, 258, 360, 225), carname = c("Mazda RX4",
"Mazda RX4 Wag", "Datsun 710", "Hornet 4 Drive", "Hornet Sportabout",
"Valiant"), wt = c(2.62, 2.875, 2.32, 3.215, 3.44, 3.46)), row.names = c("Mazda RX4",
"Mazda RX4 Wag", "Datsun 710", "Hornet 4 Drive", "Hornet Sportabout",
"Valiant"), class = "data.frame")
dataset

# plots
gg_point = ggplot(data = dataset) +
	geom_point_interactive(aes(x = wt, y = qsec, color = disp,
    tooltip = carname, data_id = carname)) + theme_minimal()

x <- girafe(ggobj = gg_point)
if( interactive() ) print(x)
}
