% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPair.R
\name{ggPair}
\alias{ggPair}
\title{Make an interactive scatter and line plot}
\usage{
ggPair(data, mapping = NULL, idcolor = TRUE, horizontal = FALSE,
  interactive = FALSE)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{idcolor}{Logical cvalue. If TRUE, row numbers uses as a color variable}

\item{horizontal}{Logical cvalue. If TRUE, coord_flip() function is used to make a horizontal plot}

\item{interactive}{Logical cvalue. If TRUE, an interactive plot using ggiraph() function will be returned}
}
\description{
Make an interactive scatter and line plot
}
\examples{
require(ggplot2)
require(ggiraph)
ggPair(iris,interactive=TRUE)
ggPair(iris[3:5],interactive=TRUE)
ggPair(iris,aes(color=Species),interactive=TRUE)
ggPair(iris,aes(color=Species),horizontal=TRUE, interactive=TRUE)
ggPair(iris,aes(x=c(Sepal.Length,Sepal.Width)),interactive=TRUE)
ggPair(iris,aes(x=c(Sepal.Length,Sepal.Width),color=Species),interactive=TRUE)
}

